const {
  Timeline,
  PRECISION_MONTH,
  PRECISION_YEAR,
  PRECISION_DECADE,
  PRECISION_CENTURY,
} = Histropedia;

const articles = [
  {
    id: 1,
    title: "Time range (day precision)",
    subtitle: "1705-3-15 → 1760-12-31",
    from: { year: 1705, month: 3, day: 15 },
    to: { year: 1760, month: 12, day: 31 },
    imageUrl: "https://picsum.photos/id/1027/600/600",
    rank: 80,
  },
  {
    id: 2,
    title: "Point in time (day precision)",
    subtitle: "1750-1-5",
    from: { year: 1750, month: 1, day: 5 },
    imageUrl: "https://picsum.photos/id/1062/600/600",
    rank: 100,
  },
  {
    id: 3,
    title: "Point in time (century precision)",
    subtitle: "19th century",
    from: { year: 1900, precision: PRECISION_CENTURY },
    imageUrl: "https://picsum.photos/id/1039/600/600",
    rank: 90,
  },
  {
    id: 4,
    title: "Time range (mixed precision)",
    subtitle: "Jun 1850 → 1960s",
    from: { year: 1850, month: 6, precision: PRECISION_MONTH },
    to: { year: 1960, precision: PRECISION_DECADE },
    imageUrl: "https://picsum.photos/id/1038/600/600",
    rank: 90,
  },
  {
    id: 5,
    title: "Ongoing time range",
    subtitle: "1980 - present",
    from: { year: 1980, precision: PRECISION_YEAR },
    isToPresent: true,
    imageUrl: "https://picsum.photos/id/1011/600/600",
    rank: 70,
  },
];

const container = document.getElementById("timeline-container");

if (!container) {
  throw new Error("Timeline container not found.");
}

const options = {
  width: container.clientWidth,
  height: container.clientHeight,
  initialDate: { year: 1650, month: 1, day: 1 },
  zoom: { initial: 47 },
};

const timeline = new Timeline(container, options);
timeline.load(articles);

// Keep the timeline sized to the current container on resize
function resizeTimeline() {
  timeline.setSize(container.clientWidth, container.clientHeight);
}

window.addEventListener("resize", resizeTimeline);
resizeTimeline();
