/*!
HistropediaJS v1.3.3 | Histropedia Ltd. (c) 2026 | https://js.histropedia.com
Use of this software is subject to our End User Licence Agreement: https://js.histropedia.com/licence.html
*/
var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
const EASINGS = {
  linear: /* @__PURE__ */ __name((t) => t, "linear"),
  swing: /* @__PURE__ */ __name((t) => 0.5 - Math.cos(t * Math.PI) / 2, "swing"),
  easeInQuad: /* @__PURE__ */ __name((t) => t * t, "easeInQuad"),
  easeOutQuad: /* @__PURE__ */ __name((t) => t * (2 - t), "easeOutQuad"),
  easeInOutQuad: /* @__PURE__ */ __name((t) => t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t, "easeInOutQuad"),
  easeInCubic: /* @__PURE__ */ __name((t) => t ** 3, "easeInCubic"),
  easeOutCubic: /* @__PURE__ */ __name((t) => --t * t * t + 1, "easeOutCubic"),
  easeInOutCubic: /* @__PURE__ */ __name((t) => t < 0.5 ? 4 * t ** 3 : 1 + --t * (2 * t) ** 2, "easeInOutCubic")
};
function tween({
  from = 0,
  to = 1,
  duration = 400,
  easing = EASINGS.linear,
  onUpdate,
  onComplete,
  autoStart = true
} = {}) {
  let startTime = null;
  let stopped = false;
  function step(now) {
    if (stopped) {
      return;
    }
    if (startTime === null) {
      startTime = now;
    }
    const t = Math.min(1, (now - startTime) / duration);
    const eased = easing(t);
    const value = from + (to - from) * eased;
    onUpdate?.(value, eased);
    if (t < 1) {
      requestAnimationFrame(step);
    } else {
      onComplete?.();
    }
  }
  __name(step, "step");
  function start() {
    stopped = false;
    startTime = null;
    requestAnimationFrame(step);
  }
  __name(start, "start");
  if (autoStart) {
    start();
  }
  return {
    /** Halt the tween at its current value (cannot be resumed) */
    stop() {
      stopped = true;
    },
    /** Restart from scratch using the same parameters */
    restart() {
      stopped = false;
      start();
    }
  };
}
__name(tween, "tween");
const MINOR_MARKER = 0;
const MAJOR_MARKER = 1;
const ERA_MARKER = 2;
const ZOOM_DAY = 0;
const ZOOM_MONTH = 1;
const ZOOM_YEAR = 2;
const ZOOM_DECADE = 3;
const ZOOM_CENTURY = 4;
const ZOOM_MILLENNIUM = 5;
const ZOOM_10_THOUSAND_YEARS = 6;
const ZOOM_100_THOUSAND_YEARS = 7;
const ZOOM_MILLION_YEARS = 8;
const ZOOM_10_MILLION_YEARS = 9;
const ZOOM_100_MILLION_YEARS = 10;
const ZOOM_BILLION_YEARS = 11;
const PRECISION_DAY = 11;
const PRECISION_MONTH = 10;
const PRECISION_YEAR = 9;
const PRECISION_DECADE = 8;
const PRECISION_CENTURY = 7;
const PRECISION_MILLENNIUM = 6;
const PRECISION_MILLION_YEARS = 3;
const PRECISION_BILLION_YEARS = 1;
const YEAR_PREFIXES = {
  //uses power of ten of prefix as key to access it's settings
  3: { label: " ka", value: 1e3 },
  6: { label: " Ma", value: 1e6 },
  9: { label: " Ga", value: 1e9 }
};
const DENSITY_LOW = 1;
const DENSITY_MEDIUM = 2;
const DENSITY_HIGH = 3;
const DENSITY_ALL = 0;
const RANGE_ALL = 0;
const RANGE_SCREEN = 1;
const DENSITY_SETTINGS = [
  { "region": 1, "zoom": { "from": 0, "to": 3.11 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 1 } },
  { "region": 2, "zoom": { "from": 3.11, "to": 6.22 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 2 } },
  { "region": 3, "zoom": { "from": 6.22, "to": 9.33 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 4 } },
  { "region": 4, "zoom": { "from": 9.33, "to": 12.44 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 8 } },
  { "region": 5, "zoom": { "from": 12.44, "to": 15.55 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 16 } },
  { "region": 6, "zoom": { "from": 15.55, "to": 18.66 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 32 } },
  { "region": 7, "zoom": { "from": 18.66, "to": 21.77 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 64 } },
  { "region": 8, "zoom": { "from": 21.77, "to": 24.88 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 128 } },
  { "region": 9, "zoom": { "from": 24.88, "to": 27.99 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 256 } },
  { "region": 10, "zoom": { "from": 27.99, "to": 31.1 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 512 } },
  { "region": 11, "zoom": { "from": 31.1, "to": 34.21 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 1024 } },
  { "region": 12, "zoom": { "from": 34.21, "to": 37.32 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 2048 } },
  { "region": 13, "zoom": { "from": 37.32, "to": 40.43 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 4096 } },
  { "region": 14, "zoom": { "from": 40.43, "to": 43.54 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 8192 } },
  { "region": 15, "zoom": { "from": 43.54, "to": 46.65 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 16384 } },
  { "region": 16, "zoom": { "from": 46.65, "to": 49.76 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 32768 } },
  { "region": 17, "zoom": { "from": 49.76, "to": 52.87 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 65536 } },
  { "region": 18, "zoom": { "from": 52.87, "to": 55.98 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 131072 } },
  { "region": 19, "zoom": { "from": 55.98, "to": 59.09 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 262144 } },
  { "region": 20, "zoom": { "from": 59.09, "to": 62.2 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 524288 } },
  { "region": 21, "zoom": { "from": 62.2, "to": 65.31 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 1048576 } },
  { "region": 22, "zoom": { "from": 65.31, "to": 68.42 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 2097152 } },
  { "region": 23, "zoom": { "from": 68.42, "to": 71.53 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 4194304 } },
  { "region": 24, "zoom": { "from": 71.53, "to": 74.64 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 8388608 } },
  { "region": 25, "zoom": { "from": 74.64, "to": 77.75 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 16777216 } },
  { "region": 26, "zoom": { "from": 77.75, "to": 80.86 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 33554432 } },
  { "region": 27, "zoom": { "from": 80.86, "to": 83.97 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 67108864 } },
  { "region": 28, "zoom": { "from": 83.97, "to": 87.08 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 134217728 } },
  { "region": 29, "zoom": { "from": 87.08, "to": 90.19 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 268435456 } },
  { "region": 30, "zoom": { "from": 90.19, "to": 93.3 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 536870912 } },
  { "region": 31, "zoom": { "from": 93.3, "to": 96.41 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 1073741824 } },
  { "region": 32, "zoom": { "from": 96.41, "to": 99.52 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 2147483648 } },
  { "region": 33, "zoom": { "from": 99.52, "to": 102.63 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 4294967296 } },
  { "region": 34, "zoom": { "from": 102.63, "to": 105.74 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 8589934592 } },
  { "region": 35, "zoom": { "from": 105.74, "to": 108.85 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 17179869184 } },
  { "region": 36, "zoom": { "from": 108.85, "to": 111.96 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 34359738368 } },
  { "region": 37, "zoom": { "from": 111.96, "to": 115.07 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 68719476736 } },
  { "region": 38, "zoom": { "from": 115.07, "to": 118.18 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 137438953472 } },
  { "region": 39, "zoom": { "from": 118.18, "to": 121.29 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 274877906944 } },
  { "region": 40, "zoom": { "from": 121.29, "to": 124.4 }, "low": 1, "medium": 2, "high": 3, "all": 25, "step": { "months": 0, "days": 549755813888 } }
];
const constants = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DENSITY_ALL,
  DENSITY_HIGH,
  DENSITY_LOW,
  DENSITY_MEDIUM,
  DENSITY_SETTINGS,
  ERA_MARKER,
  MAJOR_MARKER,
  MINOR_MARKER,
  PRECISION_BILLION_YEARS,
  PRECISION_CENTURY,
  PRECISION_DAY,
  PRECISION_DECADE,
  PRECISION_MILLENNIUM,
  PRECISION_MILLION_YEARS,
  PRECISION_MONTH,
  PRECISION_YEAR,
  RANGE_ALL,
  RANGE_SCREEN,
  YEAR_PREFIXES,
  ZOOM_100_MILLION_YEARS,
  ZOOM_100_THOUSAND_YEARS,
  ZOOM_10_MILLION_YEARS,
  ZOOM_10_THOUSAND_YEARS,
  ZOOM_BILLION_YEARS,
  ZOOM_CENTURY,
  ZOOM_DAY,
  ZOOM_DECADE,
  ZOOM_MILLENNIUM,
  ZOOM_MILLION_YEARS,
  ZOOM_MONTH,
  ZOOM_YEAR
}, Symbol.toStringTag, { value: "Module" }));
const _LoggerImpl = class _LoggerImpl {
  constructor() {
    this._enabled = false;
    this._prefix = "[Histropedia]";
    const c = typeof console !== "undefined" ? console : null;
    this._console = c;
    this._fns = {
      log: c && c.log ? c.log.bind(c) : () => {
      },
      warn: c && c.warn ? c.warn.bind(c) : () => {
      },
      error: c && c.error ? c.error.bind(c) : () => {
      },
      info: c && c.info ? c.info.bind(c) : () => {
      },
      debug: c && c.debug ? c.debug.bind(c) : c && c.log ? c.log.bind(c) : () => {
      },
      group: c && c.group ? c.group.bind(c) : c && c.log ? c.log.bind(c) : () => {
      },
      groupCollapsed: c && c.groupCollapsed ? c.groupCollapsed.bind(c) : c && c.group ? c.group.bind(c) : c && c.log ? c.log.bind(c) : () => {
      },
      groupEnd: c && c.groupEnd ? c.groupEnd.bind(c) : () => {
      }
    };
  }
  setEnabled(enabled) {
    this._enabled = !!enabled;
  }
  isEnabled() {
    return !!this._enabled;
  }
  setPrefix(prefix) {
    this._prefix = String(prefix || "");
  }
  getPrefix() {
    return this._prefix;
  }
  _withPrefixedArgs(argsArray) {
    if (!this._prefix) {
      return argsArray;
    }
    if (argsArray && argsArray.length > 0 && typeof argsArray[0] === "string") {
      const cloned = argsArray.slice();
      cloned[0] = `${this._prefix} ${cloned[0]}`;
      return cloned;
    }
    return [this._prefix, ...argsArray];
  }
  _log(method, args) {
    if (!this._enabled) {
      return;
    }
    const fn = this._fns[method] || this._fns.log;
    fn(...this._withPrefixedArgs(args));
  }
  log(...args) {
    this._log("log", args);
  }
  warn(...args) {
    this._log("warn", args);
  }
  error(...args) {
    this._log("error", args);
  }
  info(...args) {
    this._log("info", args);
  }
  debug(...args) {
    this._log("debug", args);
  }
  group(...args) {
    if (!this._enabled) {
      return;
    }
    this._fns.group(...this._withPrefixedArgs(args));
  }
  groupCollapsed(...args) {
    if (!this._enabled) {
      return;
    }
    this._fns.groupCollapsed(...this._withPrefixedArgs(args));
  }
  groupEnd() {
    if (!this._enabled) {
      return;
    }
    this._fns.groupEnd();
  }
};
__name(_LoggerImpl, "LoggerImpl");
let LoggerImpl = _LoggerImpl;
const Logger = new LoggerImpl();
const DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
const MONTH_NAMES = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
function Dmy(year, month, day) {
  if (typeof year === "object") {
    const options = year;
    this.year = options.year;
    this.month = options.month;
    this.day = getCorrectDay(options.year, options.month, options.day);
  } else {
    this.year = year;
    this.month = month;
    this.day = getCorrectDay(year, month, day);
  }
}
__name(Dmy, "Dmy");
function getCorrectDay(year, month, day) {
  return day > 28 ? Math.min(day, daysInMonth(year, month)) : day;
}
__name(getCorrectDay, "getCorrectDay");
function daysInMonth(year, month) {
  if (month == 2) {
    if (year % 4 === 0 && year % 100 !== 0 || year % 400 === 0) {
      return 29;
    }
  }
  return DAYS_IN_MONTH[month - 1];
}
__name(daysInMonth, "daysInMonth");
function digitGroupedNumber(number, separator) {
  number = number.toString();
  separator = typeof separator === "string" ? separator : ",";
  if (number.length <= 4) {
    return number;
  }
  return number.replace(/\B(?=(\d{3})+(?!\d))/g, separator);
}
__name(digitGroupedNumber, "digitGroupedNumber");
Dmy.prototype.getDaysTo = function(other) {
  return other.getDaysSinceYearZero() - this.getDaysSinceYearZero();
};
Dmy.prototype.getMonthsTo = function(other) {
  return this.getYearsTo(other) * 12;
};
Dmy.prototype.getYearsTo = function(other) {
  let yearDiff = other.year - this.year;
  yearDiff += (other.month - this.month) / 12 + (other.day - this.day) / 365.2422;
  return yearDiff;
};
Dmy.prototype.getLeapYearsSinceYearZero = function() {
  let year = this.year;
  if (this.month < 3) {
    year--;
  }
  return Math.floor(year / 4) - Math.floor(year / 100) + Math.floor(year / 400);
};
Dmy.prototype.getDaysSinceYearZero = function() {
  const year = this.year;
  let days = year * 365 + this.day;
  for (let i = 0; i < this.month - 1; i++) {
    days += DAYS_IN_MONTH[i];
  }
  days += this.getLeapYearsSinceYearZero();
  return days;
};
Dmy.prototype.getDayOfYear = function() {
  if (isUndefined(this._dayOfYear)) {
    this._dayOfYear = 0;
    for (let m = 1; m < this.month; m++) {
      this._dayOfYear += daysInMonth(this.year, m);
    }
    this._dayOfYear += this.day;
  }
  return this._dayOfYear;
};
Dmy.getByDayOfYear = function(year, dayOfYear) {
  const dmy = new Dmy(year, 1, 1);
  let dim = DAYS_IN_MONTH[0];
  for (let i = 0; i < dayOfYear - 1; i++) {
    dmy.day++;
    if (dmy.day > dim) {
      dmy.day = 1;
      dmy.month++;
      if (dmy.month > 12) {
        dmy.month = 1;
        dmy.year++;
      }
      dim = dmy.month == 2 ? daysInMonth(dmy.year, dmy.month) : DAYS_IN_MONTH[dmy.month - 1];
    }
  }
  return dmy;
};
Dmy.prototype.getNextDay = function() {
  return this.addDays(1);
};
Dmy.prototype.addDays = function(amount) {
  let day = this.day;
  let month = this.month;
  let year = this.year;
  for (let i = 0; i < amount; i++) {
    day++;
    if (day > daysInMonth(year, month)) {
      day = 1;
      month++;
      if (month > 12) {
        month = 1;
        year++;
      }
    }
  }
  return new Dmy(year, month, day);
};
Dmy.prototype.addMonths = function(amount) {
  let month = this.month;
  let year = this.year;
  for (let i = 0; i < amount; i++) {
    month++;
    if (month > 12) {
      month = 1;
      year++;
    }
  }
  return new Dmy(year, month, 1);
};
Dmy.prototype.getPreviousDay = function() {
  let day = this.day;
  let month = this.month;
  let year = this.year;
  day--;
  if (day < 1) {
    month--;
    if (month < 1) {
      month = 12;
      year--;
    }
    day = daysInMonth(year, month);
  }
  return new Dmy(year, month, day);
};
Dmy.prototype.getNextMonth = function() {
  let month = this.month;
  let year = this.year;
  month++;
  if (month > 12) {
    month = 1;
    year++;
  }
  return new Dmy(year, month, 1);
};
Dmy.prototype.getPreviousMonth = function() {
  let month = this.month;
  let year = this.year;
  month--;
  if (month < 1) {
    month = 12;
    year--;
  }
  return new Dmy(year, month, 1);
};
Dmy.prototype.addYears = function(amount) {
  return new Dmy(this.year + amount, 1, 1);
};
Dmy.prototype.format = function(format, options) {
  var options = options || {}, format = format || "D MMM YYYY", prefixSettings = options.yearPrefix, bceText = typeof options.bceText === "string" ? options.bceText : " ʙᴄᴇ", isBc = this.year <= 0, is1Bc = this.year === 0, thousandsSeparator = options.thousandsSeparator;
  if (prefixSettings && !is1Bc) {
    const prefixValue = prefixSettings.value || 1;
    const prefixLabel = prefixSettings.label || "";
    let formattedYear;
    if (isBc) {
      formattedYear = digitGroupedNumber((-this.year + 1) / prefixValue, thousandsSeparator) + prefixLabel + bceText;
    } else {
      formattedYear = digitGroupedNumber(this.year / prefixValue, thousandsSeparator) + prefixLabel;
    }
    return formattedYear;
  }
  return format.replace("YYYY", isBc ? digitGroupedNumber(-this.year + 1, thousandsSeparator) + bceText : digitGroupedNumber(this.year, thousandsSeparator)).replace("D", this.day).replace("MMM", MONTH_NAMES[this.month - 1]);
};
Dmy.prototype.isSame = function(other) {
  return other.year == this.year && other.month == this.month && other.day == this.day;
};
Dmy.prototype.toKeyString = function() {
  return `${this.year}|${this.month}|${this.day}`;
};
Dmy.prototype.isAfter = function(other) {
  if (this.year > other.year) {
    return true;
  }
  if (this.year == other.year) {
    if (this.month > other.month) {
      return true;
    }
    if (this.month == other.month) {
      return this.day > other.day;
    }
  }
  return false;
};
Dmy.prototype.isBetween = function(from, to) {
  return this.isAfter(from) && to.isAfter(this);
};
Dmy.prototype.compare = function(other) {
  if (this.isSame(other)) {
    return 0;
  }
  if (this.isAfter(other)) {
    return 1;
  }
  return -1;
};
Dmy.prototype.asFloat = function() {
  const m = this.month - 1;
  const d = this.day - 1;
  if (m == 0 && d == 0) {
    return this.year;
  }
  return Math.round((this.year + (m * 31 + d) / 371) * 100) / 100;
};
Dmy.prototype.isInFuture = function() {
  const date = /* @__PURE__ */ new Date();
  const today = new Dmy(date.getFullYear(), date.getMonth() + 1, date.getDate());
  return this.isAfter(today);
};
Dmy.prototype.convertToIso = function() {
  if (this.year < 0) {
    this.year += 1;
  }
  return this;
};
Dmy.CreateAsStartOfPeriod = function(isoDmy, precision) {
  const isoYear = isoDmy.year;
  const month = isoDmy.month || 1;
  const day = isoDmy.day || 1;
  var precision = precision || PRECISION_DAY;
  if (precision === PRECISION_CENTURY) {
    return isoYear < 0 ? new Dmy(isoYear, 1, 1) : new Dmy(isoYear - 99, 1, 1);
  }
  if (precision === PRECISION_MILLENNIUM) {
    return isoYear < 0 ? new Dmy(isoYear, 1, 1) : new Dmy(isoYear - 999, 1, 1);
  }
  return new Dmy(isoYear, month, day);
};
Dmy.CreateAsEndOfPeriod = function(isoDmy, precision) {
  const isoYear = isoDmy.year;
  const month = isoDmy.month || 1;
  const day = isoDmy.day || 1;
  var precision = precision || PRECISION_DAY;
  if (precision === PRECISION_DAY) {
    return new Dmy(isoYear, month, day);
  }
  if (precision === PRECISION_MONTH) {
    return new Dmy(isoYear, month, daysInMonth(isoYear, month));
  }
  if (precision === PRECISION_YEAR) {
    return new Dmy(isoYear, 12, 31);
  }
  if (precision === PRECISION_DECADE) {
    return new Dmy(isoYear + 9, 12, 31);
  }
  const isBc = isoYear <= 0;
  if (precision === PRECISION_CENTURY) {
    return isBc ? new Dmy(isoYear + 99, 12, 31) : new Dmy(isoYear, 12, 31);
  }
  if (precision == PRECISION_MILLENNIUM) {
    return isBc ? new Dmy(isoYear + 999, 12, 31) : new Dmy(isoYear, 12, 31);
  }
  if (precision == PRECISION_MILLION_YEARS) {
    return new Dmy(isoYear + 999999, 12, 31);
  }
  if (precision == PRECISION_BILLION_YEARS) {
    return new Dmy(isoYear + 999999999, 12, 31);
  }
  Logger.error("precision is not implemented");
  return new Dmy(isoYear, month, day);
};
Dmy.now = function() {
  const now = /* @__PURE__ */ new Date();
  return new Dmy({
    year: now.getYear() + 1900,
    month: now.getMonth() + 1,
    day: now.getDate()
  });
};
Dmy.fromString = function(dateString) {
  const dateParts = dateString.split("-");
  const isBc = dateParts[0] === "";
  if (isBc) {
    dateParts.shift();
    dateParts[0] = `-${dateParts[0]}`;
  }
  const year = parseInt(dateParts[0]);
  const month = parseInt(dateParts[1]) || 1;
  const day = parseInt(dateParts[2]) || 1;
  return new Dmy({
    year: parseInt(year),
    month: parseInt(month),
    day: parseInt(day)
  });
};
function merge(target, ...sources) {
  return Object.assign(target, ...sources);
}
__name(merge, "merge");
function deepMerge(target, ...sources) {
  const ensureSafeProto = /* @__PURE__ */ __name((obj) => {
    if (obj && typeof obj === "object" && !Object.prototype.hasOwnProperty.call(obj, "__proto__")) {
      try {
        Object.defineProperty(obj, "__proto__", {
          value: void 0,
          writable: true,
          enumerable: false,
          configurable: true
        });
      } catch (_) {
      }
    }
  }, "ensureSafeProto");
  ensureSafeProto(target);
  const isUnsafeKey = /* @__PURE__ */ __name((key) => key === "__proto__" || key === "constructor" || key === "prototype", "isUnsafeKey");
  const isPlainObject = /* @__PURE__ */ __name((obj) => {
    if (obj === null || typeof obj !== "object") {
      return false;
    }
    const proto = Object.getPrototypeOf(obj);
    return proto === Object.prototype || proto === null;
  }, "isPlainObject");
  for (const src of sources) {
    if (!src || typeof src !== "object") {
      continue;
    }
    for (const k of Object.keys(src)) {
      if (isUnsafeKey(k)) {
        continue;
      }
      const v = src[k];
      if (Array.isArray(v)) {
        target[k] = v.slice();
        continue;
      }
      if (isPlainObject(v)) {
        const base = isPlainObject(target[k]) ? target[k] : {};
        ensureSafeProto(base);
        target[k] = deepMerge(base, v);
        continue;
      }
      target[k] = v;
    }
  }
  ensureSafeProto(target);
  return target;
}
__name(deepMerge, "deepMerge");
function buildObjectFromPath(path, value) {
  const pathParts = path.split(".");
  const pathEnd = pathParts[pathParts.length - 1];
  let obj = {};
  obj[pathEnd] = value;
  for (let i = pathParts.length - 2; i >= 0; i--) {
    const previousPathPart = pathParts[i];
    const objClone = deepMerge({}, obj);
    obj = {};
    obj[previousPathPart] = objClone;
  }
  return obj;
}
__name(buildObjectFromPath, "buildObjectFromPath");
function defineValueOrFunctionProperty(obj, propName) {
  const privatePropertyName = `_${propName}`;
  obj[privatePropertyName] = void 0;
  Object.defineProperty(obj, propName, {
    get() {
      const value = this[privatePropertyName];
      if (typeof value === "function") {
        return value(this);
      }
      return value;
    },
    set(value) {
      this[privatePropertyName] = value;
    },
    enumerable: true,
    configurable: false
  });
}
__name(defineValueOrFunctionProperty, "defineValueOrFunctionProperty");
function isUndefined$1(value) {
  return typeof value === "undefined";
}
__name(isUndefined$1, "isUndefined$1");
const propertyAbbreviations = {
  "id": "i",
  "title": "t",
  "rank": "r",
  "subtitle": "s",
  "from.year": "fy",
  "from.month": "fm",
  "from.day": "fd",
  "from.precision": "fp",
  "to.year": "ty",
  "to.month": "tm",
  "to.day": "td",
  "to.precision": "tp",
  "isToPresent": "p",
  "isStarred": "v",
  "offset.left": "ol",
  "offset.top": "ot",
  "imageUrl": "m",
  "style": "st",
  "activeStyle": "ast",
  "hiddenByFilter": "h",
  "hidePeriodLine": "hp"
};
function extractProperty(data, property) {
  return data.hasOwnProperty(property) ? data[property] : data[propertyAbbreviations[property]];
}
__name(extractProperty, "extractProperty");
function extractPropertyFromPath(data, path) {
  const pathParts = path.split(".");
  return pathParts.reduce((curr, next) => curr ? curr[next] : void 0, data);
}
__name(extractPropertyFromPath, "extractPropertyFromPath");
function isPath(property) {
  return property.indexOf(".") > -1;
}
__name(isPath, "isPath");
function getPropertyFromData(data, property) {
  if (isPath(property)) {
    return extractPropertyFromPath(data, property);
  }
  return extractProperty(data, property);
}
__name(getPropertyFromData, "getPropertyFromData");
function existsInData(data, property) {
  if (isPath(property)) {
    return !isUndefined$1(extractPropertyFromPath(data, property));
  }
  return data.hasOwnProperty(property);
}
__name(existsInData, "existsInData");
defineValueOrFunctionProperty(Article.prototype, "hidePeriodLine");
defineValueOrFunctionProperty(Article.prototype, "hiddenByFilter");
function Article(owner, id) {
  this.id = id;
  this.owner = owner;
  this.isDataLoaded = false;
  this.imageLoaded = false;
  this.stacking = 0;
  this.groupIndex = 0;
  this.isActive = false;
  this.isVisible = false;
  this.isInRange = false;
  this.isInView = false;
  this.isVisibleInGroup = false;
  this.isVisibleInRows = true;
  this.isStarred = false;
  this.isMouseOverStar = false;
  this.isMouseover = false;
  this.isDragging = false;
  this.registeredPosition = { left: 0, top: 0 };
  this.position = { left: 0, top: 0 };
  this.dragStartOffset = { left: 0, top: 0 };
  this.indicator = { fromX: 0, toX: 0 };
  this.offset = { left: 0, top: 0 };
  this.finalOffset = { left: 0, top: 0 };
  this.isVisibleAfterFade = false;
  this.opacity = 0;
  this.fadeAnimation = {
    finalOpacity: 0,
    dummyElement: null
  };
  this.moveAnimation = {
    finalOffset: { left: 0, top: 0 },
    dummyElement: void 0
  };
  this.row = 0;
  this.isFading = false;
  this.isMoving = false;
  this._cachedHeight = 0;
  this._cachedWidth = 0;
  this._sizeValid = false;
  this._sizeCacheKey = null;
  this._layoutCaches = null;
}
__name(Article, "Article");
Article.prototype.setupByReceivedData = function(receivedData) {
  const articleDefaultData = this.owner.options.article.defaultData;
  const data = deepMerge({}, articleDefaultData, receivedData);
  if (!existsInData(receivedData, "to")) {
    delete data.to;
  }
  this.data = deepMerge({}, receivedData);
  this.title = getPropertyFromData(data, "title") || "";
  this.rank = getPropertyFromData(data, "rank") || 0;
  this.subtitle = getPropertyFromData(data, "subtitle") || "";
  this._setupArticlePeriod(data);
  this.offset.left = this.finalOffset.left = this.moveAnimation.finalOffset.left = data.offsetLeft || 0;
  this.offset.top = this.finalOffset.top = this.moveAnimation.finalOffset.top = data.offsetTop || 0;
  this.isStarred = !!data.starred;
  this.cardLayout = getPropertyFromData(data, "cardLayout") || null;
  this.initialiseStyles(data);
  this.hiddenByFilter = getPropertyFromData(data, "hiddenByFilter");
  this.hidePeriodLine = existsInData(data, "hidePeriodLine") ? getPropertyFromData(data, "hidePeriodLine") : this.owner.options.article.periodLine.defaultHide;
  this.isDataLoaded = true;
  this.isImageInfoLoaded = false;
};
Article.prototype._setupArticlePeriod = function(data) {
  const fromDmy = new Dmy(
    parseInt(getPropertyFromData(data, "from.year")),
    parseInt(getPropertyFromData(data, "from.month")),
    parseInt(getPropertyFromData(data, "from.day"))
  );
  this.owner.getDmyFromInput(fromDmy);
  const fromPrecision = parseInt(getPropertyFromData(data, "from.precision"));
  const isToPresentProp = getPropertyFromData(data, "isToPresent");
  const isToPresent = isToPresentProp === true || isToPresentProp === 1;
  let toDmy, toPrecision;
  if (isToPresent) {
    toDmy = Dmy.now();
  } else if (existsInData(data, "to")) {
    toDmy = new Dmy(
      parseInt(getPropertyFromData(data, "to.year")),
      parseInt(getPropertyFromData(data, "to.month")),
      parseInt(getPropertyFromData(data, "to.day"))
    );
    this.owner.getDmyFromInput(toDmy);
    toPrecision = parseInt(getPropertyFromData(data, "to.precision"));
  } else {
    toDmy = fromDmy;
    toPrecision = fromPrecision;
  }
  const from = Dmy.CreateAsStartOfPeriod(fromDmy, fromPrecision);
  const to = Dmy.CreateAsEndOfPeriod(toDmy, toPrecision);
  this.period = { from, to: to.getNextDay(), isToPresent };
  this.period.years = this.period.to.asFloat() - this.period.from.asFloat();
};
Article.prototype.setImage = function() {
  this.isImageInfoLoaded = true;
  if (getPropertyFromData(this.data, "imageUrl")) {
    this.owner.enqueueImageLoad(this);
  } else {
    this._releaseImageResource();
    this.image = null;
    this.imageLoaded = false;
  }
};
Article.prototype._releaseImageResource = function(options = {}) {
  const releaser = typeof this._closeImage === "function" ? this._closeImage : null;
  if (releaser) {
    this._closeImage = null;
    try {
      releaser(options);
    } catch (_) {
    }
    return;
  }
  if (!options.keepState) {
    this.image = null;
    this.imageLoaded = false;
    this._loadedImageKey = null;
  }
};
Article.prototype.registerPosition = function(pos) {
  this.registeredPosition = this.position = pos;
};
Article.prototype.overlaps = function(other) {
  return other.period.from.isSame(this.period.from) && other.period.to.isSame(this.period.to) || other.period.from.isBetween(this.period.from, this.period.to) || other.period.to.isBetween(this.period.from, this.period.to) || this.period.from.isBetween(other.period.from, other.period.to) || this.period.to.isBetween(other.period.from, other.period.to);
};
Article.prototype.overlapsInclusiveWithDates = function(from, to) {
  return !(this.period.from.isAfter(to) || from.isAfter(this.period.to));
};
Article.prototype.overlapsInclusive = function(other) {
  return this.overlapsInclusiveWithDates(other.period.from, other.period.to);
};
Article.prototype.isInside = function(pos) {
  if (!this.isVisible) {
    return false;
  }
  this._ensureSizeCache();
  const left = this.position.left;
  const top = this.position.top;
  const width = this._cachedWidth;
  const height = this._cachedHeight;
  return pos.left >= left && pos.left <= left + width && pos.top >= top && pos.top <= top + height;
};
Article.prototype.pointerEnter = function(event) {
  this.isMouseover = true;
  this.owner.trigger("article-pointerenter", this, event);
};
Article.prototype.pointerLeave = function(event) {
  this.isMouseover = false;
  this.owner.trigger("article-pointerleave", this, event);
};
Article.prototype.updateIsMouseOverStar = function(pos) {
  const star = this.getIconBox();
  if (!star) {
    return false;
  }
  const oldState = this.isMouseOverStar;
  this.isMouseOverStar = pos.left >= star.left && pos.left <= star.left + star.width && pos.top >= star.top && pos.top <= star.top + star.height;
  if (this.isMouseOverStar != oldState && !this.owner.isAnimating) {
    this.owner.redraw();
  }
  return this.isMouseOverStar;
};
Article.prototype.getCursor = function(pos) {
  const cursor = this.owner.options.style.cursor;
  if (this.isDragging) {
    return cursor.article.dragging;
  }
  this.updateIsMouseOverStar(pos);
  if (!this.owner.options.article.draggable) {
    return cursor.clickable;
  }
  if (this.isActive) {
    return this.isMouseOverStar ? cursor.clickable : cursor.article.hoverDraggable;
  }
  return cursor.clickable;
};
Article.prototype.clicked = function(pos) {
  this.updateIsMouseOverStar(pos);
  if (this.isMouseOverStar) {
    this.isStarred = !this.isStarred;
    return true;
  }
  return false;
};
Article.prototype.getStatusForSave = function() {
  const state = { i: this.id };
  if (this.offset.left != 0) {
    state.l = this.offset.left;
  }
  if (this.offset.top != 0) {
    state.t = this.offset.top;
  }
  if (this.isStarred) {
    state.v = true;
  }
  return state;
};
Article.prototype.headerOverlapsWith = function(other) {
  const thisLeft = this.registeredPosition.left;
  const otherLeft = other.registeredPosition.left;
  const thisRight = thisLeft + this.getWidth();
  const otherRight = otherLeft + other.getWidth();
  return otherRight >= thisLeft && thisRight >= otherLeft;
};
Article.prototype._getWidth = function() {
  return this._getCurrentStyle().width;
};
Article.prototype.getWidth = function() {
  this._ensureSizeCache();
  return this._cachedWidth;
};
Article.prototype.getHeight = function() {
  this._ensureSizeCache();
  return this._cachedHeight;
};
Article.prototype.setOption = function(option, value) {
  let needsDefaultRedraw = false;
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      const selectedOption = getPropertyFromData(this.data, option);
      return selectedOption;
    }
    option = buildObjectFromPath(option, value);
  }
  deepMerge(this.data, option);
  if (existsInData(option, "id")) {
    this.id = option.id;
  }
  if (existsInData(option, "title")) {
    this.title = option.title;
    this.titleLines = void 0;
  }
  if (existsInData(option, "subtitle")) {
    this.subtitle = option.subtitle;
    this.summarisedSubtitle = void 0;
  }
  if (existsInData(option, "from") || existsInData(option, "to") || existsInData(option, "isToPresent")) {
    this._setupArticlePeriod(this.data);
    needsDefaultRedraw = true;
  }
  if (existsInData(option, "imageUrl")) {
    this.setImage();
  }
  if (existsInData(option, "rank")) {
    this.rank = option.rank;
    needsDefaultRedraw = true;
  }
  if (existsInData(option, "starred")) {
    this.isStarred = option.starred;
  }
  if (existsInData(option, "hiddenByFilter")) {
    this.hiddenByFilter = option.hiddenByFilter;
  }
  if (existsInData(option, "hidePeriodLine")) {
    this.hidePeriodLine = option.hidePeriodLine;
  }
  const styleChanged = existsInData(option, "style");
  const activeStyleChanged = existsInData(option, "activeStyle");
  const hoverStyleChanged = existsInData(option, "hoverStyle");
  const timelineOptions = this.owner.options.article;
  let activeHoverStyleUpdated = false;
  if (styleChanged) {
    this.initialiseStyles(this.data);
    this.invalidateCaches();
  } else {
    if (hoverStyleChanged) {
      deepMerge(this.hoverStyle, option.hoverStyle);
      this.activeHoverStyle = deepMerge(
        {},
        this.hoverStyle,
        timelineOptions.defaultActiveStyle,
        this.data.activeStyle
      );
      activeHoverStyleUpdated = true;
    }
    if (activeStyleChanged) {
      this.activeStyle = deepMerge(this.activeStyle, option.activeStyle);
      if (!activeHoverStyleUpdated) {
        deepMerge(this.activeHoverStyle, option.activeStyle);
      }
    }
    this.invalidateCaches();
  }
  const cardLayoutChanged = existsInData(option, "cardLayout");
  if (cardLayoutChanged) {
    this.setCardLayout(option.cardLayout);
  }
  if (needsDefaultRedraw) {
    this.owner.requestRedraw();
  } else {
    this.owner.requestRedraw(this.redraw);
  }
};
Article.prototype.initialiseStyles = function(data = this.data) {
  const articleOptions = this.owner.options.article;
  const cardLayout = this._getCurrentCardLayoutName();
  const layoutStyles = articleOptions.layoutStyles[cardLayout] || {};
  const style = deepMerge(
    {},
    articleOptions.defaultStyle,
    layoutStyles.style || {},
    getPropertyFromData(data, "style") || {}
  );
  const activeStyle = deepMerge(
    {},
    articleOptions.defaultActiveStyle,
    layoutStyles.activeStyle || {},
    getPropertyFromData(data, "activeStyle") || {}
  );
  const hoverStyle = deepMerge(
    {},
    articleOptions.defaultHoverStyle,
    layoutStyles.hoverStyle || {},
    getPropertyFromData(data, "hoverStyle") || {}
  );
  this.style = style;
  this.activeStyle = deepMerge({}, style, activeStyle);
  this.hoverStyle = deepMerge({}, style, hoverStyle);
  this.activeHoverStyle = deepMerge({}, this.hoverStyle, activeStyle);
};
Article.prototype.setStyle = function(option, value) {
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      return getPropertyFromData(this.style, option);
    }
    option = buildObjectFromPath(option, value);
  }
  this.data.style = deepMerge(this.data.style || {}, option);
  this.initialiseStyles(this.data);
  this.invalidateCaches();
  this.owner.requestRedraw();
};
Article.prototype.setHoverStyle = function(option, value) {
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      return getPropertyFromData(this.activeStyle, option);
    }
    option = buildObjectFromPath(option, value);
  }
  this.data.hoverStyle = deepMerge(this.data.hoverStyle || {}, option);
  deepMerge(this.hoverStyle, option);
  this.activeHoverStyle = deepMerge(
    {},
    this.hoverStyle,
    this.owner.options.article.defaultActiveStyle,
    this.data.activeStyle
  );
  this.owner.requestRedraw();
};
Article.prototype.setActiveStyle = function(option, value) {
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      return getPropertyFromData(this.activeStyle, option);
    }
    option = buildObjectFromPath(option, value);
  }
  this.data.activeStyle = deepMerge(this.data.activeStyle || {}, option);
  deepMerge(this.activeStyle, option);
  deepMerge(this.activeHoverStyle, option);
  this.owner.requestRedraw();
};
Article.prototype.updateVisibility = function() {
  const oldVisibility = this.isVisibleAfterFade;
  const newVisibility = this.isInRange && this.isVisibleInGroup && this.isVisibleInRows && !this.isHiddenByFilter;
  if (oldVisibility == newVisibility) {
    return;
  }
  if (newVisibility && !this.isImageInfoLoaded) {
    this.setImage();
  }
  if (!this.owner.options.article.animation.fade.active) {
    this.setVisibility(newVisibility);
    return;
  }
  this.setVisibilityWithFade(newVisibility);
};
Article.prototype.setVisibility = function(visibility) {
  this.isVisible = this.isVisibleAfterFade = this.opacity = visibility;
  if (!visibility) {
    this._releaseImageResource({ skipRedraw: true });
  }
};
Article.prototype.setVisibilityWithFade = function(visibility) {
  const me = this;
  if (visibility === me.isVisibleAfterFade) {
    return;
  }
  if (me.isFading && me.fadeAnimation?.dummyElement?.stop) {
    me.fadeAnimation.dummyElement.stop();
  }
  me.isFading = true;
  me.isVisibleAfterFade = visibility;
  me.fadeAnimation = me.fadeAnimation || {};
  me.fadeAnimation.finalOpacity = visibility;
  if (visibility) {
    me.isVisible = true;
  }
  me.owner.notifyArticleAnimating("fade", me.id);
  const settings = me.owner.options.article.animation.fade;
  const duration = settings.duration ?? 400;
  const easingName = settings.easing ?? "swing";
  const easingFn = EASINGS[easingName] || EASINGS.swing;
  const startOpacity = me.opacity;
  const endOpacity = visibility ? 1 : 0;
  const fadeTween = tween({
    from: startOpacity,
    to: endOpacity,
    duration,
    easing: easingFn,
    /** Fired every animation frame */
    onUpdate(value) {
      me.opacity = value;
      me.owner.requestRedraw();
    },
    /** Finalise */
    onComplete() {
      me.isFading = false;
      if (!visibility) {
        me.isVisible = false;
        me._releaseImageResource({ skipRedraw: true });
      }
      const last = me.owner.lastAnimatingArticle;
      if (me.id === last.id && last.animationType === "fade") {
        me.owner.isAnimatingArticles = false;
      }
      if (typeof settings.complete === "function") {
        settings.complete.call(me);
      }
    }
  });
  me.fadeAnimation.dummyElement = fadeTween;
};
Article.prototype.moveToOffset = function(destination) {
  this.finalOffset.top = this.offset.top = destination.top || this.offset.top;
  this.finalOffset.left = this.offset.left = destination.left || this.offset.left;
  this.position.top = this.registeredPosition.top + this.offset.top;
  this.position.left = this.registeredPosition.left + this.offset.left;
};
Article.prototype.moveTo = function(destination) {
  const finalOffset = {
    left: destination.left - this.registeredPosition.left,
    top: destination.top - this.registeredPosition.top
  };
  this.moveToOffset(finalOffset);
};
Article.prototype.moveToWithAnim = function(destination) {
  const finalOffset = {
    left: destination.left - this.registeredPosition.left,
    top: destination.top - this.registeredPosition.top
  };
  this.moveToOffsetWithAnim(finalOffset);
};
Article.prototype.moveToOffsetWithAnim = function(destination) {
  const me = this;
  const moveAnimation = me.moveAnimation;
  if (destination.top === moveAnimation.finalOffset.top && destination.left === moveAnimation.finalOffset.left) {
    return;
  }
  if (me.isMoving && moveAnimation?.dummyElement?.stop) {
    moveAnimation.dummyElement.stop();
  }
  moveAnimation.finalOffset = this.finalOffset = {
    left: destination.left,
    top: destination.top
  };
  me.isMoving = true;
  me.owner.notifyArticleAnimating("move", me.id);
  const settings = me.owner.options.article.animation.move;
  const duration = settings.duration ?? 400;
  const easingName = settings.easing ?? "swing";
  const easingFn = EASINGS[easingName] || EASINGS.swing;
  const startTop = me.offset.top;
  const startLeft = me.offset.left;
  const deltaTop = destination.top - startTop;
  const deltaLeft = destination.left - startLeft;
  const moveTween = tween({
    from: 0,
    to: 1,
    duration,
    easing: easingFn,
    onUpdate(progress) {
      me.offset.top = startTop + deltaTop * progress;
      me.offset.left = startLeft + deltaLeft * progress;
      me.position.top = me.registeredPosition.top + me.offset.top;
      me.position.left = me.registeredPosition.left + me.offset.left;
      me.owner.requestRedraw();
    },
    onComplete() {
      me.offset.top = destination.top;
      me.offset.left = destination.left;
      me.position.top = me.registeredPosition.top + destination.top;
      me.position.left = me.registeredPosition.left + destination.left;
      me.isMoving = false;
      const last = me.owner.lastAnimatingArticle;
      if (me.id === last.id && last.animationType === "move") {
        me.owner.isAnimatingArticles = false;
      }
    }
  });
  moveAnimation.dummyElement = moveTween;
};
Article.prototype.draw = function(ctx) {
  if (!this.isDataLoaded || isNaN(this.position.left)) {
    return;
  }
  this._ensureSizeCache();
  ctx.globalAlpha = this.opacity;
  const cardLayout = this._getCurrentCardLayout();
  cardLayout.draw.call(this, ctx);
};
Article.prototype._getCurrentStyle = function() {
  if (this.isActive) {
    return this.isMouseover ? this.activeHoverStyle : this.activeStyle;
  }
  return this.isMouseover ? this.hoverStyle : this.style;
};
Article.prototype.drawPeriodLinesAndConnectors = function(ctx, top) {
  ctx.globalAlpha = this.opacity;
  const style = this._getCurrentStyle();
  const effectivePeriodLineSize = this.hidePeriodLine ? 0 : this.owner.options.article.periodLine.spacing;
  const effectivePeriodLineThickness = this.hidePeriodLine ? 0 : this.owner.options.article.periodLine.thickness;
  const offset = (effectivePeriodLineSize + effectivePeriodLineThickness) * this.stacking;
  const y = top - offset - this.owner.options.style.mainLine.size / 2 - effectivePeriodLineThickness / 2;
  if (!this.hidePeriodLine) {
    const fromX = this.indicator.fromX, toX = this.indicator.toX;
    ctx.beginPath();
    ctx.lineWidth = effectivePeriodLineThickness;
    ctx.moveTo(fromX, y);
    ctx.lineTo(toX, y);
    if (this.period.isToPresent) {
      const periodLength = toX - fromX, maxFadeLength = 15, fadeStartColorStop = Math.max(1 - maxFadeLength / periodLength, 0.7), grad = ctx.createLinearGradient(fromX, y, toX, y);
      grad.addColorStop(0, style.color);
      grad.addColorStop(fadeStartColorStop, style.color);
      grad.addColorStop(1, "rgba(255,255,255,0)");
      ctx.strokeStyle = grad;
    } else {
      ctx.strokeStyle = style.color;
    }
    ctx.stroke();
  }
  if (!style.connectorLine.visible) {
    return;
  }
  const x1 = Math.max(0, this.indicator.fromX);
  const y1 = y;
  const x2 = this.position.left + style.connectorLine.offsetX;
  const y2 = this.position.top + this.getHeight() + style.connectorLine.offsetY;
  ctx.strokeStyle = ctx.fillStyle = style.color;
  ctx.lineWidth = style.connectorLine.thickness;
  ctx.beginPath();
  ctx.moveTo(x1, y1);
  ctx.lineTo(x2, y2);
  ctx.stroke();
  const radians = Math.atan((y2 - y1) / (x2 - x1)) + (x2 >= x1 ? -90 : 90) * Math.PI / 180;
  ctx.save();
  ctx.beginPath();
  ctx.translate(x2, y2);
  ctx.rotate(radians);
  ctx.moveTo(-style.connectorLine.arrow.width, 0);
  ctx.lineTo(style.connectorLine.arrow.width, 0);
  ctx.lineTo(0, -style.connectorLine.arrow.height);
  ctx.closePath();
  ctx.restore();
  ctx.fill();
};
Article.prototype.getIconBox = function() {
  const cardLayout = this._getCurrentCardLayout();
  return cardLayout.getIconBox.call(this);
};
Article.prototype.startDragging = function(pos, evt) {
  if (this.isMoving) {
    this.moveAnimation.dummyElement.stop();
  }
  this.isDragging = true;
  this.dragInitialPosition = { left: this.position.left, top: this.position.top };
  this.lastDragPosition = { left: this.position.left, top: this.position.top };
  this.dragStartOffset = {
    left: pos.left - this.position.left,
    top: pos.top - this.position.top
  };
  this.owner.startAnimation();
  if (this.owner && typeof this.owner.trigger === "function") {
    this.owner.trigger("article-drag-start", this, evt);
  }
};
Article.prototype.stopDragging = function(evt) {
  this.offset = this.finalOffset = this.moveAnimation.finalOffset = {
    left: this.position.left - this.registeredPosition.left,
    top: this.position.top - this.registeredPosition.top
  };
  this.isDragging = false;
  if (this.owner && typeof this.owner.trigger === "function") {
    this.owner.trigger("article-drag-end", this, evt);
  }
};
Article.prototype.dragging = function(pos, evt) {
  const newPosition = {
    left: pos.left - this.dragStartOffset.left,
    top: pos.top - this.dragStartOffset.top
  };
  const previousPosition = this.lastDragPosition || { left: this.position.left, top: this.position.top };
  const initialPosition = this.dragInitialPosition || previousPosition;
  const dx = newPosition.left - previousPosition.left;
  const dy = newPosition.top - previousPosition.top;
  const totalDx = newPosition.left - initialPosition.left;
  const totalDy = newPosition.top - initialPosition.top;
  this.position = newPosition;
  this.lastDragPosition = newPosition;
  if (this.owner && typeof this.owner.trigger === "function") {
    this.owner.trigger(
      "article-drag",
      this,
      { dx, dy, totalDx, totalDy },
      evt
    );
  }
};
Article.prototype._cacheBucket = function() {
  const name = this._getCurrentCardLayoutName();
  if (!this._layoutCaches) {
    this._layoutCaches = /* @__PURE__ */ Object.create(null);
  }
  return this._layoutCaches[name] || (this._layoutCaches[name] = /* @__PURE__ */ Object.create(null));
};
Article.prototype.memo = function(key, factory) {
  const bucket = this._cacheBucket();
  return key in bucket ? bucket[key] : bucket[key] = factory.call(this);
};
Article.prototype._getSizeCacheKey = function() {
  const style = typeof this._getCurrentStyle === "function" ? this._getCurrentStyle() : null;
  const imageStyle = style && style.image || {};
  const header = style && style.header || {};
  const subheader = style && style.subheader || {};
  const border = style && style.border || {};
  const layout = typeof this._getCurrentCardLayoutName === "function" ? this._getCurrentCardLayoutName() : "";
  const hasImage = this.imageLoaded && this.image;
  const keyParts = [
    layout,
    style && style.width,
    style && style.height,
    header.height,
    subheader.height,
    border.width,
    imageStyle.margin ?? 0,
    imageStyle.shape || "",
    imageStyle.maxHeight ?? "",
    style && style.maxImageHeight !== void 0 ? style.maxImageHeight : "",
    hasImage ? this.image.width : "noimg",
    hasImage ? this.image.height : ""
  ];
  return keyParts.join("|");
};
Article.prototype.updateCachedSize = function() {
  const cardLayout = this._getCurrentCardLayout();
  this._cachedWidth = cardLayout.getWidth.call(this);
  this._cachedHeight = cardLayout.getHeight.call(this);
  this.height = this._cachedHeight;
  this._sizeValid = true;
  this._sizeCacheKey = this._getSizeCacheKey();
};
Article.prototype._ensureSizeCache = function() {
  const cacheKey = this._getSizeCacheKey();
  if (!this._sizeValid || cacheKey !== this._sizeCacheKey) {
    this.updateCachedSize();
  }
};
Article.prototype.invalidateCaches = function() {
  this._sizeValid = false;
  this._sizeCacheKey = null;
  if (this._layoutCaches) {
    const buckets = this._layoutCaches;
    for (const layoutName in buckets) {
      const bucket = buckets[layoutName];
      if (!bucket) {
        continue;
      }
      for (const k in bucket) {
        const v = bucket[k];
        if (v && typeof v.close === "function") {
          try {
            v.close();
          } catch (_) {
          }
        }
      }
    }
  }
  this._layoutCaches = null;
};
Article.prototype._getCurrentCardLayoutName = function() {
  return this.cardLayout || this.owner.options.article.defaultCardLayout;
};
Article.prototype._getCurrentCardLayout = function() {
  return this.owner.getCardLayout(this._getCurrentCardLayoutName());
};
Article.prototype.setCardLayout = function(cardLayout) {
  const layout = this.owner.getCardLayout(cardLayout);
  if (!layout) {
    throw new Error(`Card layout "${cardLayout}" not found`);
  }
  this.cardLayout = cardLayout;
  this.initialiseStyles();
  this.invalidateCaches();
  this.owner.requestRedraw(this.redraw);
};
function compareArticleIds(idA, idB) {
  const numA = Number(idA);
  const numB = Number(idB);
  const idsAreNumeric = Number.isFinite(numA) && Number.isFinite(numB);
  if (idsAreNumeric) {
    return numA - numB;
  }
  const strA = String(idA);
  const strB = String(idB);
  if (strA === strB) {
    return 0;
  }
  return strA < strB ? -1 : 1;
}
__name(compareArticleIds, "compareArticleIds");
function ARTICLE_DURATION_SORTER(articleA, articleB) {
  const a = articleA.period.from.getDaysTo(articleA.period.to);
  const b = articleB.period.from.getDaysTo(articleB.period.to);
  if (a < b) {
    return 1;
  }
  if (a > b) {
    return -1;
  }
  return compareArticleIds(articleA.id, articleB.id);
}
__name(ARTICLE_DURATION_SORTER, "ARTICLE_DURATION_SORTER");
function ARTICLE_DURATION_YEARS_SORTER(articleA, articleB) {
  const a = articleA.period.years;
  const b = articleB.period.years;
  if (a < b) {
    return 1;
  }
  if (a > b) {
    return -1;
  }
  return compareArticleIds(articleA.id, articleB.id);
}
__name(ARTICLE_DURATION_YEARS_SORTER, "ARTICLE_DURATION_YEARS_SORTER");
function ARTICLE_IMAGE_QUEUE_SORTER(articleA, articleB) {
  const a = articleA.isInView && articleA.isVisible;
  const b = articleB.isInView && articleB.isVisible;
  if (!a && b) {
    return -1;
  }
  if (a && !b) {
    return 1;
  }
  return articleA.position.top - articleB.position.top;
}
__name(ARTICLE_IMAGE_QUEUE_SORTER, "ARTICLE_IMAGE_QUEUE_SORTER");
function ARTICLE_FROM_SORTER(articleA, articleB) {
  const a = articleA.period.from;
  const b = articleB.period.from;
  let result = a.compare(b);
  if (result == 0) {
    result = compareArticleIds(articleB.id, articleA.id);
  }
  return result;
}
__name(ARTICLE_FROM_SORTER, "ARTICLE_FROM_SORTER");
function ARTICLE_TO_SORTER(articleA, articleB) {
  const a = articleA.period.to;
  const b = articleB.period.to;
  let result = b.compare(a);
  if (result == 0) {
    result = compareArticleIds(articleB.id, articleA.id);
  }
  return result;
}
__name(ARTICLE_TO_SORTER, "ARTICLE_TO_SORTER");
function ARTICLE_TOP_SORTER(articleA, articleB) {
  const a = articleA.position.top;
  const b = articleB.position.top;
  if (a < b) {
    return -1;
  }
  if (a > b) {
    return 1;
  }
  return compareArticleIds(articleB.id, articleA.id);
}
__name(ARTICLE_TOP_SORTER, "ARTICLE_TOP_SORTER");
function ARTICLE_ROW_SORTER(articleA, articleB) {
  const a = articleA.row;
  const b = articleB.row;
  if (a < b) {
    return 1;
  }
  if (a > b) {
    return -1;
  }
  return compareArticleIds(articleB.id, articleA.id);
}
__name(ARTICLE_ROW_SORTER, "ARTICLE_ROW_SORTER");
function ARTICLE_RANK_SORTER(articleA, articleB) {
  const a = articleA.rank;
  const b = articleB.rank;
  if (a < b) {
    return 1;
  }
  if (a > b) {
    return -1;
  }
  return compareArticleIds(articleB.id, articleA.id);
}
__name(ARTICLE_RANK_SORTER, "ARTICLE_RANK_SORTER");
function ARTICLE_EFFECTIVE_RANK_SORTER(articleA, articleB) {
  const a = articleA.effectiveRank;
  const b = articleB.effectiveRank;
  if (a < b) {
    return 1;
  }
  if (a > b) {
    return -1;
  }
  return compareArticleIds(articleB.id, articleA.id);
}
__name(ARTICLE_EFFECTIVE_RANK_SORTER, "ARTICLE_EFFECTIVE_RANK_SORTER");
function ARTICLE_POSITION_SORTER(articleA, articleB) {
  const a = articleA.position.left;
  const b = articleB.position.left;
  let result = a < b ? 1 : a > b ? -1 : 0;
  if (result == 0) {
    result = articleA.position.top - articleB.position.top;
    if (result == 0) {
      result = articleA.period.from.compare(articleB.period.from);
      if (result == 0) {
        result = compareArticleIds(articleA.id, articleB.id);
      }
    }
  }
  return result;
}
__name(ARTICLE_POSITION_SORTER, "ARTICLE_POSITION_SORTER");
const sorters = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ARTICLE_DURATION_SORTER,
  ARTICLE_DURATION_YEARS_SORTER,
  ARTICLE_EFFECTIVE_RANK_SORTER,
  ARTICLE_FROM_SORTER,
  ARTICLE_IMAGE_QUEUE_SORTER,
  ARTICLE_POSITION_SORTER,
  ARTICLE_RANK_SORTER,
  ARTICLE_ROW_SORTER,
  ARTICLE_TOP_SORTER,
  ARTICLE_TO_SORTER
}, Symbol.toStringTag, { value: "Module" }));
function moveInArray(arr, oldIndex, newIndex) {
  if (newIndex >= arr.length) {
    let k = newIndex - arr.length;
    while (k-- + 1) {
      arr.push(void 0);
    }
  }
  arr.splice(newIndex, 0, arr.splice(oldIndex, 1)[0]);
  return arr;
}
__name(moveInArray, "moveInArray");
function findMinIndex(arr, property) {
  if (arr.length === 0) {
    return -1;
  }
  let minIndex = 0;
  let minValue = arr[0][property];
  for (let i = 1; i < arr.length; i++) {
    if (arr[i][property] < minValue) {
      minValue = arr[i][property];
      minIndex = i;
    }
  }
  return minIndex;
}
__name(findMinIndex, "findMinIndex");
function clamp(value, min, max) {
  if (value < min) {
    return min;
  }
  if (value > max) {
    return max;
  }
  return value;
}
__name(clamp, "clamp");
const _FontWatcher = class _FontWatcher {
  constructor(invalidateCb) {
    this.invalidateCb = invalidateCb;
    this.seen = /* @__PURE__ */ new Set();
    this.loading = /* @__PURE__ */ new Set();
    this.loaded = /* @__PURE__ */ new Set();
    if (typeof document !== "undefined" && document.fonts && document.fonts.addEventListener) {
      document.fonts.addEventListener("loadingdone", (ev) => {
        for (const ff of ev.fontfaces) {
          this._notifyFamily(ff.family);
        }
      });
    }
  }
  /**
   * Call BEFORE you measure with `ctx.font = fontString`.
   * Safe to call repeatedly with the same string.
   */
  use(fontString) {
    if (!fontString || this.loading.has(fontString) || this.loaded.has(fontString)) {
      return;
    }
    this.seen.add(fontString);
    if (typeof document !== "undefined" && document.fonts && document.fonts.load) {
      this.loading.add(fontString);
      document.fonts.load(fontString).then(() => {
        this.loading.delete(fontString);
        this.loaded.add(fontString);
        this.invalidateCb(fontString);
      }).catch((error) => {
        Logger.warn("[FontWatcher] Font load failed:", fontString, error);
        this.loading.delete(fontString);
      });
    }
  }
  /** When `loadingdone` fires we get only the *family* name. */
  _notifyFamily(family) {
    for (const fs of this.seen) {
      if (fs.includes(family)) {
        this.loading.delete(fs);
        this.loaded.add(fs);
        this.invalidateCb(fs);
      }
    }
  }
};
__name(_FontWatcher, "FontWatcher");
let FontWatcher = _FontWatcher;
const DEFAULT_CACHE_BYTES = 64 * 1024 * 1024;
const SQUARE_SHAPES = /* @__PURE__ */ new Set(["square", "circle"]);
const VALID_DECODE_MODES = /* @__PURE__ */ new Set(["auto", "prefer-bitmap", "bitmap", "prefer-img", "img"]);
function isPositiveFinite(value) {
  return typeof value === "number" && Number.isFinite(value) && value > 0;
}
__name(isPositiveFinite, "isPositiveFinite");
function clampDimension(value) {
  return Math.max(1, Math.floor(value || 0));
}
__name(clampDimension, "clampDimension");
const _ImageLoader = class _ImageLoader {
  constructor(options = {}) {
    const {
      maxConcurrent = 6,
      maxCacheBytes,
      requireCORS = false,
      decodeMode = "auto"
    } = options;
    this.maxConcurrent = Math.max(1, maxConcurrent | 0);
    this.requireCORS = !!requireCORS;
    let resolvedBytes;
    if (typeof maxCacheBytes === "number") {
      resolvedBytes = Number.isFinite(maxCacheBytes) ? Math.max(0, maxCacheBytes) : Infinity;
    } else {
      resolvedBytes = DEFAULT_CACHE_BYTES;
    }
    this.maxCacheBytes = resolvedBytes;
    let mode = typeof decodeMode === "string" ? decodeMode.toLowerCase() : "auto";
    if (!VALID_DECODE_MODES.has(mode)) {
      mode = "auto";
    }
    this.decodeMode = mode;
    this.queue = [];
    this.active = 0;
    this.cache = /* @__PURE__ */ new Map();
    this.totalBytes = 0;
    this.inflight = /* @__PURE__ */ new Map();
  }
  enqueue(key, url, onReady, options = {}) {
    if (!key || !url || typeof onReady !== "function") {
      return () => {
      };
    }
    const shape = typeof options.shape === "string" ? options.shape.toLowerCase() : "natural";
    const request = {
      key,
      url,
      onReady,
      options: {
        targetW: isPositiveFinite(options.targetW) ? options.targetW : null,
        targetH: isPositiveFinite(options.targetH) ? options.targetH : null,
        shape,
        article: options.article || null
      },
      cancelled: false,
      delivered: false
    };
    const cached = this.cache.get(key);
    if (cached) {
      const release = this._acquire(cached, request.options.article);
      request.delivered = true;
      try {
        onReady(cached.image, cached.tainted, cached.kind, cached.close, release);
      } catch (err) {
        release({ keepState: true, skipRedraw: true });
        throw err;
      }
      return () => {
      };
    }
    const inflight = this.inflight.get(key);
    if (inflight) {
      inflight.requests.push(request);
    } else if (request.options.article && request.options.article.isInView) {
      this.queue.unshift(request);
    } else {
      this.queue.push(request);
    }
    this._pump();
    return () => this._cancel(request);
  }
  _cancel(request) {
    if (!request || request.cancelled || request.delivered) {
      return;
    }
    request.cancelled = true;
    const inflight = this.inflight.get(request.key);
    if (inflight) {
      const idx = inflight.requests.indexOf(request);
      if (idx !== -1) {
        inflight.requests.splice(idx, 1);
      }
      if (inflight.requests.length === 0) {
        try {
          inflight.controller?.abort();
        } catch (_) {
        }
      }
    } else {
      const idx = this.queue.indexOf(request);
      if (idx !== -1) {
        this.queue.splice(idx, 1);
      }
    }
  }
  _pump() {
    if (this.active >= this.maxConcurrent) {
      return;
    }
    while (this.active < this.maxConcurrent && this.queue.length) {
      const request = this.queue.shift();
      if (!request || request.cancelled) {
        continue;
      }
      const article = request.options && request.options.article;
      if (article && article.isInRange === false) {
        request.cancelled = true;
        try {
          if (article._pendingImageKey === request.key) {
            article._pendingImageKey = null;
            if (typeof article._imageCancel === "function") {
              article._imageCancel = null;
            }
          }
        } catch (_) {
        }
        continue;
      }
      if (this.cache.has(request.key)) {
        this._serveFromCache(request);
        continue;
      }
      const inflight = this.inflight.get(request.key);
      if (inflight) {
        inflight.requests.push(request);
        continue;
      }
      this._startLoad(request);
    }
  }
  _serveFromCache(request) {
    const entry = this.cache.get(request.key);
    if (!entry || request.cancelled) {
      return;
    }
    const release = this._acquire(entry, request.options.article);
    request.delivered = true;
    try {
      request.onReady(entry.image, entry.tainted, entry.kind, entry.close, release);
    } catch (err) {
      release({ keepState: true, skipRedraw: true });
      throw err;
    }
  }
  _startLoad(request) {
    const controller = typeof AbortController !== "undefined" ? new AbortController() : null;
    const inflightEntry = { requests: [request], controller };
    this.inflight.set(request.key, inflightEntry);
    this.active++;
    const signal = controller ? controller.signal : void 0;
    const loadPromise = this._loadResource(request, signal);
    inflightEntry.promise = loadPromise;
    loadPromise.then((entry) => {
      if (!entry) {
        return;
      }
      const existing = this.cache.get(request.key);
      if (existing) {
        this._evictEntry(request.key, existing);
      }
      entry.key = request.key;
      entry.refs = 0;
      entry.articles = /* @__PURE__ */ new Set();
      entry.lastUsed = this._now();
      this.cache.set(request.key, entry);
      this.totalBytes += entry.bytes || 0;
      const consumers = inflightEntry.requests.slice();
      for (const req of consumers) {
        if (!req || req.cancelled) {
          continue;
        }
        const release = this._acquire(entry, req.options.article);
        req.delivered = true;
        try {
          req.onReady(entry.image, entry.tainted, entry.kind, entry.close, release);
        } catch (err) {
          release({ keepState: true, skipRedraw: true });
          throw err;
        }
      }
      this._trimCache();
    }).catch(() => {
    }).finally(() => {
      this.inflight.delete(request.key);
      this.active = Math.max(0, this.active - 1);
      this._pump();
    });
  }
  _acquire(entry, article) {
    entry.refs = (entry.refs || 0) + 1;
    entry.lastUsed = this._now();
    if (article) {
      entry.articles.add(article);
    }
    let released = false;
    const release = /* @__PURE__ */ __name((options = {}) => {
      if (released) {
        return;
      }
      released = true;
      this._releaseInternal(entry.key, article, options);
    }, "release");
    release._key = entry.key;
    if (article) {
      release._article = article;
    }
    return release;
  }
  _releaseInternal(key, article, options = {}) {
    const entry = this.cache.get(key);
    if (!entry) {
      return;
    }
    if (entry.refs > 0) {
      entry.refs -= 1;
    }
    entry.lastUsed = this._now();
    if (article && entry.articles instanceof Set) {
      entry.articles.delete(article);
    }
    this._dropArticleState(article, key, options);
    this._trimCache();
  }
  _dropArticleState(article, key, options) {
    if (!article || !key) {
      return;
    }
    const keepState = !!options.keepState;
    const skipRedraw = !!options.skipRedraw;
    if (!keepState && article._loadedImageKey === key) {
      article.imageLoaded = false;
      article.image = null;
      article._loadedImageKey = null;
      if (typeof article._cacheBucket === "function") {
        try {
          const bucket = article._cacheBucket();
          const rasterKey = `imageRaster:${key}`;
          if (bucket && Object.prototype.hasOwnProperty.call(bucket, rasterKey)) {
            delete bucket[rasterKey];
          }
        } catch (_) {
        }
      }
      if (typeof article.updateCachedSize === "function") {
        try {
          article.updateCachedSize();
        } catch (_) {
        }
      }
      const owner = article.owner;
      if (!skipRedraw && owner && typeof owner.requestRedraw === "function") {
        try {
          owner.requestRedraw();
        } catch (_) {
        }
      }
    }
    if (article._closeImage && article._closeImage._key === key) {
      article._closeImage = null;
    }
  }
  _trimCache() {
    if (!Number.isFinite(this.maxCacheBytes)) {
      return;
    }
    if (this.totalBytes <= this.maxCacheBytes) {
      return;
    }
    const candidates = [];
    for (const [key, entry] of this.cache.entries()) {
      if (entry) {
        candidates.push({ key, entry });
      }
    }
    candidates.sort((a, b) => {
      const aTime = typeof a.entry.lastUsed === "number" ? a.entry.lastUsed : 0;
      const bTime = typeof b.entry.lastUsed === "number" ? b.entry.lastUsed : 0;
      return aTime - bTime;
    });
    for (const { key, entry } of candidates) {
      if (this.totalBytes <= this.maxCacheBytes) {
        break;
      }
      if (entry.refs > 0) {
        continue;
      }
      this._evictEntry(key, entry);
    }
  }
  _evictEntry(key, entry) {
    if (!this.cache.has(key)) {
      return;
    }
    this.cache.delete(key);
    this.totalBytes = Math.max(0, this.totalBytes - (entry.bytes || 0));
    if (entry && typeof entry.close === "function") {
      try {
        entry.close();
      } catch (_) {
      }
    }
  }
  async _loadResource(request, signal) {
    if (!request || request.cancelled) {
      return null;
    }
    const mode = this.decodeMode;
    const supportsBitmap = typeof createImageBitmap === "function";
    const loadBitmap = /* @__PURE__ */ __name(async (strict) => {
      if (!supportsBitmap) {
        if (strict) {
          throw new Error("ImageBitmap not supported");
        }
        return null;
      }
      try {
        return await this._loadViaFetch(request, signal);
      } catch (err) {
        if (strict) {
          throw err;
        }
      }
      try {
        return await this._loadViaImageElement(request, true);
      } catch (err) {
        if (strict) {
          throw err;
        }
        return null;
      }
    }, "loadBitmap");
    const loadImg = /* @__PURE__ */ __name(async (allowBitmapFallback) => {
      try {
        return await this._loadViaImageElement(request, false);
      } catch (err) {
        if (!allowBitmapFallback) {
          throw err;
        }
        return await loadBitmap(false);
      }
    }, "loadImg");
    switch (mode) {
      case "bitmap":
        return await loadBitmap(true);
      case "prefer-bitmap":
      case "auto": {
        const bitmapEntry = await loadBitmap(false);
        if (bitmapEntry) {
          return bitmapEntry;
        }
        return await loadImg(false);
      }
      case "prefer-img": {
        const imgEntry = await loadImg(true);
        if (imgEntry) {
          return imgEntry;
        }
        return await loadBitmap(false);
      }
      case "img":
        return await loadImg(false);
      default: {
        const bitmapEntry = await loadBitmap(false);
        if (bitmapEntry) {
          return bitmapEntry;
        }
        return await loadImg(false);
      }
    }
  }
  async _loadViaFetch(request, signal) {
    const fetchOptions = {
      signal,
      mode: "cors",
      credentials: this.requireCORS ? "same-origin" : "omit"
    };
    const response = await fetch(request.url, fetchOptions);
    if (!response.ok) {
      throw new Error("image fetch failed");
    }
    const blob = await response.blob();
    const baseBitmap = await createImageBitmap(blob);
    const transform = this._computeTransform(request.options, baseBitmap.width, baseBitmap.height);
    let bitmap = baseBitmap;
    if (transform.needsCrop || transform.needsResize) {
      const cropWidth = transform.sw;
      const cropHeight = transform.sh;
      const opts = {};
      if (transform.resizeWidth) {
        opts.resizeWidth = transform.resizeWidth;
      }
      if (transform.resizeHeight) {
        opts.resizeHeight = transform.resizeHeight;
      }
      bitmap = await createImageBitmap(
        baseBitmap,
        transform.sx,
        transform.sy,
        cropWidth,
        cropHeight,
        opts
      );
      try {
        baseBitmap.close();
      } catch (_) {
      }
    }
    return this._buildEntryFromBitmap(bitmap, false);
  }
  async _loadViaImageElement(request, allowBitmap) {
    const img = await this._createImageElement(request.url);
    const width = clampDimension(img.naturalWidth || img.width || 0);
    const height = clampDimension(img.naturalHeight || img.height || 0);
    const shape = request.options.shape || "natural";
    const transform = this._computeTransform(request.options, width, height);
    if (!allowBitmap && shape === "natural") {
      transform.needsResize = false;
      transform.resizeWidth = null;
      transform.resizeHeight = null;
    }
    if (allowBitmap && typeof createImageBitmap === "function") {
      const opts = {};
      if (transform.resizeWidth) {
        opts.resizeWidth = transform.resizeWidth;
      }
      if (transform.resizeHeight) {
        opts.resizeHeight = transform.resizeHeight;
      }
      const bitmap = await createImageBitmap(
        img,
        transform.sx,
        transform.sy,
        transform.sw,
        transform.sh,
        opts
      );
      return this._buildEntryFromBitmap(bitmap, !this.requireCORS);
    }
    if (transform.needsCrop || transform.needsResize) {
      const canvas = this._drawToCanvas(img, transform);
      return this._buildEntryFromCanvas(canvas, !this.requireCORS);
    }
    return {
      image: img,
      kind: "img",
      tainted: !this.requireCORS,
      close: /* @__PURE__ */ __name(() => {
      }, "close"),
      bytes: this._estimateBytes(width, height)
    };
  }
  _drawToCanvas(img, transform) {
    let targetWidth = transform.resizeWidth != null ? transform.resizeWidth : transform.sw;
    let targetHeight = transform.resizeHeight != null ? transform.resizeHeight : transform.sh;
    if (transform.resizeWidth != null && transform.resizeHeight == null && transform.sw > 0) {
      const scale = transform.resizeWidth / transform.sw;
      targetHeight = Math.max(1, Math.round(transform.sh * scale));
    } else if (transform.resizeHeight != null && transform.resizeWidth == null && transform.sh > 0) {
      const scale = transform.resizeHeight / transform.sh;
      targetWidth = Math.max(1, Math.round(transform.sw * scale));
    }
    targetWidth = Math.max(1, Math.round(targetWidth));
    targetHeight = Math.max(1, Math.round(targetHeight));
    const canvas = this._createCanvas(targetWidth, targetHeight);
    const ctx = canvas.getContext && canvas.getContext("2d");
    if (!ctx) {
      return canvas;
    }
    ctx.drawImage(
      img,
      transform.sx,
      transform.sy,
      transform.sw,
      transform.sh,
      0,
      0,
      targetWidth,
      targetHeight
    );
    return canvas;
  }
  _createCanvas(width, height) {
    const w = clampDimension(width);
    const h = clampDimension(height);
    if (typeof document !== "undefined" && typeof document.createElement === "function") {
      const canvas = document.createElement("canvas");
      canvas.width = w;
      canvas.height = h;
      return canvas;
    }
    if (typeof OffscreenCanvas !== "undefined") {
      return new OffscreenCanvas(w, h);
    }
    return { width: w, height: h, getContext: /* @__PURE__ */ __name(() => null, "getContext") };
  }
  _buildEntryFromBitmap(bitmap, tainted) {
    const close = /* @__PURE__ */ __name(() => {
      try {
        bitmap.close();
      } catch (_) {
      }
    }, "close");
    return {
      image: bitmap,
      kind: "bitmap",
      tainted,
      close,
      bytes: this._estimateBytes(bitmap.width, bitmap.height)
    };
  }
  _buildEntryFromCanvas(canvas, tainted) {
    const close = /* @__PURE__ */ __name(() => {
      if (typeof canvas.close === "function") {
        try {
          canvas.close();
        } catch (_) {
        }
      }
    }, "close");
    return {
      image: canvas,
      kind: "canvas",
      tainted,
      close,
      bytes: this._estimateBytes(canvas.width, canvas.height)
    };
  }
  _computeTransform(options, width, height) {
    const result = {
      sx: 0,
      sy: 0,
      sw: clampDimension(width),
      sh: clampDimension(height),
      resizeWidth: null,
      resizeHeight: null,
      needsCrop: false,
      needsResize: false
    };
    const shape = options.shape || "natural";
    if (SQUARE_SHAPES.has(shape)) {
      if (result.sw !== result.sh) {
        if (result.sw > result.sh) {
          result.sx = Math.floor((result.sw - result.sh) / 2);
          result.sw = result.sh;
        } else {
          result.sy = Math.floor((result.sh - result.sw) / 2);
          result.sh = result.sw;
        }
        result.needsCrop = true;
      }
      const size = options.targetW || options.targetH;
      if (isPositiveFinite(size)) {
        const clamped = clampDimension(size);
        result.resizeWidth = clamped;
        result.resizeHeight = clamped;
        result.needsResize = true;
      }
    } else {
      const targetW = options.targetW;
      const targetH = options.targetH;
      const sw = result.sw;
      const sh = result.sh;
      const applyScale = /* @__PURE__ */ __name((scale) => {
        if (!Number.isFinite(scale) || scale <= 0) {
          return;
        }
        const newW = clampDimension(sw * scale);
        const newH = clampDimension(sh * scale);
        if (newW === sw && newH === sh) {
          return;
        }
        result.resizeWidth = newW;
        result.resizeHeight = newH;
        result.needsResize = true;
      }, "applyScale");
      if (isPositiveFinite(targetW) && isPositiveFinite(targetH)) {
        const scale = Math.min(targetW / sw, targetH / sh);
        applyScale(scale);
      } else if (isPositiveFinite(targetW)) {
        applyScale(targetW / sw);
      } else if (isPositiveFinite(targetH)) {
        applyScale(targetH / sh);
      }
    }
    if (result.resizeWidth != null && result.resizeHeight == null) {
      result.resizeHeight = clampDimension(result.sh);
    } else if (result.resizeHeight != null && result.resizeWidth == null) {
      result.resizeWidth = clampDimension(result.sw);
    }
    return result;
  }
  _estimateBytes(width, height) {
    return clampDimension(width) * clampDimension(height) * 4;
  }
  _now() {
    if (typeof performance !== "undefined" && typeof performance.now === "function") {
      return performance.now();
    }
    return Date.now();
  }
  _createImageElement(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      if (this.requireCORS) {
        img.crossOrigin = "anonymous";
      }
      img.decoding = "async";
      img.fetchPriority = "low";
      img.onload = () => resolve(img);
      img.onerror = () => reject(new Error("image load error"));
      img.src = url;
      if (typeof img.decode === "function") {
        img.decode().then(() => resolve(img)).catch(() => {
        });
      }
    });
  }
};
__name(_ImageLoader, "ImageLoader");
let ImageLoader = _ImageLoader;
const _TimescaleManager = class _TimescaleManager {
  constructor(owner, zoomOptions) {
    this.owner = owner;
    this.zoomOptions = zoomOptions;
    this.zoom = 0;
    this.startToken = null;
    this.unit = ZOOM_DAY;
    this.unitSizeInPixels = 100;
    this.unitLengthInYears = 1;
    this.zoomChangedHandlers = [];
    this.yearPrefix = {
      //updated by setCurrentYearPrefixes()
      minor: false,
      major: false
    };
    this.unitLevels = [];
  }
};
__name(_TimescaleManager, "TimescaleManager");
let TimescaleManager = _TimescaleManager;
TimescaleManager.prototype.getUnitSizeInPixelsForZoom = function(zoom) {
  const zoomRatio = this.zoomOptions.ratio;
  const currentUnitSettings = this.unitLevels[this.unit];
  const zoomStart = currentUnitSettings.zoomStart;
  const startUnitSize = currentUnitSettings.startUnitSize;
  return startUnitSize * Math.pow(zoomRatio, zoom - zoomStart);
};
TimescaleManager.prototype.getChangePoint = function(unit) {
  this.unitLevels;
  return this.unitLevels[this.unit].zoomStart;
};
TimescaleManager.prototype.getUnitFromZoom = function(zoom) {
  const unitLevels = this.unitLevels;
  for (let i = unitLevels.length - 1; i < unitLevels.length; i--) {
    if (zoom >= unitLevels[i].zoomStart) {
      return i;
    }
  }
};
TimescaleManager.prototype.getDateLabelFormatOptions = function(tokenType) {
  tokenType = tokenType === MAJOR_MARKER ? "major" : "minor";
  const dateLabelFormatOptions = this.owner.options.style.dateLabel[tokenType];
  return {
    thousandsSeparator: dateLabelFormatOptions.thousandsSeparator,
    bceText: dateLabelFormatOptions.bceText,
    yearPrefix: this.yearPrefix[tokenType]
  };
};
TimescaleManager.prototype.createYearToken = function(dmy) {
  const token = {
    unit: this.unit,
    value: dmy,
    length: this.unitSizeInPixels
  };
  let year = dmy.year;
  const is1BC = year == 0;
  if (year <= 0) {
    year = -year + 1;
  }
  const unitLengthInYears = this.unitLengthInYears;
  const unitSettings = this.unitLevels[this.unit];
  if (year % (unitLengthInYears * 10) === 0 || is1BC) {
    token.label = dmy.format("YYYY", this.getDateLabelFormatOptions(MAJOR_MARKER));
    token.type = MAJOR_MARKER;
  } else {
    token.type = MINOR_MARKER;
    if (this.zoom < unitSettings.zoomHideMinorLabels) {
      token.label = dmy.format("YYYY", this.getDateLabelFormatOptions(MINOR_MARKER));
    }
  }
  return token;
};
TimescaleManager.prototype.createMonthToken = function(dmy) {
  const token = {
    unit: this.unit,
    value: dmy,
    length: this.unitSizeInPixels
  };
  const unitSettings = this.unitLevels[ZOOM_MONTH];
  if (dmy.month == 1) {
    token.label = dmy.format("YYYY", this.getDateLabelFormatOptions(MAJOR_MARKER));
    token.type = MAJOR_MARKER;
  } else {
    token.type = MINOR_MARKER;
    if (this.zoom < unitSettings.zoomHideMinorLabels) {
      token.label = dmy.format("MMM");
    }
  }
  return token;
};
TimescaleManager.prototype.createDayToken = function(dmy) {
  const token = {
    unit: this.unit,
    value: dmy,
    length: this.unitSizeInPixels
  };
  const unitSettings = this.unitLevels[ZOOM_DAY];
  if (dmy.day == 1) {
    token.label = dmy.format("MMM YYYY", this.getDateLabelFormatOptions(MAJOR_MARKER));
    token.type = MAJOR_MARKER;
  } else {
    token.type = MINOR_MARKER;
    if (this.zoom < unitSettings.zoomHideMinorLabels) {
      token.label = dmy.format("D");
    }
  }
  return token;
};
TimescaleManager.prototype.addZoomChangedHandler = function(handler, context) {
  this.zoomChangedHandlers.push({ callback: handler, context: context || this });
};
TimescaleManager.prototype.notifyZoomChanged = function() {
  for (let i = 0; i < this.zoomChangedHandlers.length; i++) {
    this.zoomChangedHandlers[i].callback.call(this.zoomChangedHandlers[i].context);
  }
};
TimescaleManager.prototype.setZoom = function(value) {
  const previousZoom = this.zoom;
  let nextZoom = parseFloat(value.toFixed(4));
  if (nextZoom < this.zoomOptions.minimum) {
    nextZoom = this.zoomOptions.minimum;
  }
  if (nextZoom > this.zoomOptions.maximum) {
    nextZoom = this.zoomOptions.maximum;
  }
  this.zoom = nextZoom;
  this.unit = this.getUnitFromZoom(this.zoom);
  this.unitSizeInPixels = this.getUnitSizeInPixelsForZoom(this.zoom);
  let unitLengthInYears = 0;
  if (this.unit >= ZOOM_YEAR) {
    const unitYearPowerOfTen = this.unit - ZOOM_YEAR;
    unitLengthInYears = Math.pow(10, unitYearPowerOfTen);
  }
  this.unitLengthInYears = unitLengthInYears;
  this.setCurrentYearPrefixes();
  if (this.owner._isInitialized) {
    const zoomDelta = this.zoom - previousZoom;
    this.owner.trigger("zoom", { zoom: this.zoom, zoomDelta });
  }
  this.owner._emitTimelineStateChange();
  this.notifyZoomChanged();
  return this.zoom;
};
TimescaleManager.prototype.getPixelsBetween = function(a, b) {
  const unit = this.unit;
  if (unit <= ZOOM_DAY) {
    return a.getDaysTo(b) * this.unitSizeInPixels;
  }
  if (unit === ZOOM_MONTH) {
    return a.getMonthsTo(b) * this.unitSizeInPixels;
  } else {
    return a.getYearsTo(b) * this.unitSizeInPixels / this.unitLengthInYears;
  }
};
TimescaleManager.prototype.setStartToken = function(token) {
  return this.startToken = token;
};
TimescaleManager.prototype.setStartDate = function(from) {
  let bcMove = 0;
  if (from.year < 0) {
    bcMove = 1;
  }
  switch (this.unit) {
    case ZOOM_DAY:
      this.startToken = this.createDayToken(from);
      return 0;
    case ZOOM_MONTH:
      this.startToken = this.createMonthToken(new Dmy(from.year, from.month, 1));
      var unitSizeForDays = this.unitSizeInPixels / 30.44;
      return unitSizeForDays * (this.startToken.value.day - from.day);
    case ZOOM_YEAR:
      this.startToken = this.createYearToken(new Dmy(from.year, 1, 1));
      var unitSizeForDays = this.unitSizeInPixels / 365.2422;
      return unitSizeForDays * ((this.startToken.value.month - from.month) * 30.44 + (this.startToken.value.day - from.day));
    default:
      var tokenLengthInYears = this.unitLengthInYears;
      this.startToken = this.createYearToken(new Dmy(Math.floor(from.year / tokenLengthInYears) * tokenLengthInYears + bcMove, 1, 1));
      var unitSizeForDays = this.unitSizeInPixels / (365.2422 * tokenLengthInYears);
      return unitSizeForDays * ((this.startToken.value.year - from.year) * 365.2422 + (this.startToken.value.month - from.month) * 30.44 + (this.startToken.value.day - from.day));
  }
};
TimescaleManager.prototype.getStartTokenCloned = function() {
  switch (this.startToken.unit) {
    case ZOOM_DAY:
      return this.createDayToken(this.startToken.value);
    case ZOOM_MONTH:
      return this.createMonthToken(this.startToken.value);
    default:
      return this.createYearToken(this.startToken.value);
  }
};
TimescaleManager.prototype.getNext = function(token) {
  switch (token.unit) {
    case ZOOM_DAY:
      return this.createDayToken(token.value.getNextDay());
    case ZOOM_MONTH:
      return this.createMonthToken(token.value.getNextMonth());
    case ZOOM_YEAR:
      return this.createYearToken(token.value.addYears(1));
    default:
      var unitLengthInYears = this.unitLengthInYears;
      return this.createYearToken(token.value.addYears(token.value.year == -(unitLengthInYears - 1) ? unitLengthInYears - 1 : unitLengthInYears));
  }
};
TimescaleManager.prototype.getPrevious = function(token) {
  switch (token.unit) {
    case ZOOM_DAY:
      return this.createDayToken(token.value.getPreviousDay());
    case ZOOM_MONTH:
      return this.createMonthToken(token.value.getPreviousMonth());
    case ZOOM_YEAR:
      return this.createYearToken(token.value.addYears(-1));
    default:
      var unitLengthInYears = this.unitLengthInYears;
      return this.createYearToken(token.value.addYears(token.value.year == 0 ? 1 - unitLengthInYears : -unitLengthInYears));
  }
};
TimescaleManager.prototype.getPreviousNth = function(token, n) {
  for (let i = 0; i < n; i++) {
    token = this.getPrevious(token);
  }
  return token;
};
TimescaleManager.prototype.zoomUnitToString = function(unit) {
  switch (unit) {
    case ZOOM_DAY:
      return "day";
    case ZOOM_MONTH:
      return "month";
    case ZOOM_YEAR:
      return "year";
    case ZOOM_DECADE:
      return "decade";
    case ZOOM_CENTURY:
      return "century";
    case ZOOM_MILLENNIUM:
      return "millennium";
    case ZOOM_10_THOUSAND_YEARS:
      return "10 thousand years";
    case ZOOM_100_THOUSAND_YEARS:
      return "100 thousand years";
    case ZOOM_MILLION_YEARS:
      return "million years";
    case ZOOM_10_MILLION_YEARS:
      return "10 million years";
    case ZOOM_100_MILLION_YEARS:
      return "100 million years";
    case ZOOM_BILLION_YEARS:
      return "billion years";
    default:
      return "unknown";
  }
};
TimescaleManager.prototype.setUnitLevels = function() {
  this.unitLevels = [];
  this.zoomOptions.ratio;
  const minUnitSize = this.zoomOptions.unitSize.minimum;
  const showMinorLabelUnitSize = this.zoomOptions.unitSize.showMinorLabels;
  const dayZoomStart = 0;
  const hideLabelsZoomChangeFromEnd = this.getZoomChangeByDistance(showMinorLabelUnitSize, minUnitSize);
  const dayStartUnitSize = this.zoomOptions.unitSize.initial;
  const dayZoomSpan = this.getZoomChangeByDistance(dayStartUnitSize, minUnitSize);
  const dayZoomEnd = dayZoomStart + dayZoomSpan;
  const dayZoomHideMinorLabels = dayZoomEnd - hideLabelsZoomChangeFromEnd;
  const daySettings = {
    startUnitSize: dayStartUnitSize,
    zoomStart: dayZoomStart,
    zoomHideMinorLabels: dayZoomHideMinorLabels,
    zoomEnd: dayZoomEnd
  };
  this.unitLevels.push(daySettings);
  const monthStartUnitSize = minUnitSize * 31;
  const monthZoomSpan = this.getZoomChangeByDistance(monthStartUnitSize, minUnitSize);
  const monthZoomEnd = dayZoomEnd + monthZoomSpan;
  const monthZoomHideMinorLabels = monthZoomEnd - hideLabelsZoomChangeFromEnd;
  this.unitLevels.push({
    startUnitSize: monthStartUnitSize,
    zoomStart: dayZoomEnd,
    zoomHideMinorLabels: monthZoomHideMinorLabels,
    zoomEnd: monthZoomEnd
  });
  const yearStartUnitSize = minUnitSize * 12;
  const yearZoomSpan = this.getZoomChangeByDistance(yearStartUnitSize, minUnitSize);
  const yearZoomEnd = monthZoomEnd + yearZoomSpan;
  const yearZoomHideMinorLabels = yearZoomEnd - hideLabelsZoomChangeFromEnd;
  this.unitLevels.push({
    startUnitSize: yearStartUnitSize,
    zoomStart: monthZoomEnd,
    zoomHideMinorLabels: yearZoomHideMinorLabels,
    zoomEnd: yearZoomEnd
  });
  let startUnitSize;
  let zoomSpan;
  let zoomStart = yearZoomEnd;
  let zoomEnd;
  let zoomHideMinorLabels;
  const numberOfUnits = 8;
  for (let i = 1; i <= numberOfUnits; i++) {
    startUnitSize = minUnitSize * 10;
    zoomSpan = this.getZoomChangeByDistance(startUnitSize, minUnitSize);
    zoomEnd = zoomStart + zoomSpan;
    zoomHideMinorLabels = zoomEnd - hideLabelsZoomChangeFromEnd;
    this.unitLevels.push({
      startUnitSize,
      zoomStart,
      zoomHideMinorLabels,
      zoomEnd
    });
    zoomStart = zoomEnd;
    if (i === numberOfUnits) {
      this.zoomOptions.maximum = Math.min(this.zoomOptions.maximum, zoomEnd);
    }
  }
};
TimescaleManager.prototype.getZoomChangeByDistance = function(startDistance, endDistance) {
  const zoomRatio = this.zoomOptions.ratio;
  const zoom = Math.log(endDistance / startDistance) / Math.log(zoomRatio);
  return zoom;
};
TimescaleManager.prototype.scaleDistanceByZoomChange = function(startDistance, zoomChange) {
  const zoomRatio = this.zoomOptions.ratio;
  const endDistance = startDistance * Math.pow(zoomRatio, zoomChange);
  return endDistance;
};
TimescaleManager.prototype.setCurrentYearPrefixes = function() {
  const markerTypes = ["minor", "major"];
  if (this.unit < ZOOM_YEAR) {
    for (var i = 0; i < markerTypes.length; i++) {
      this.yearPrefix[markerTypes[i]] = false;
    }
    return;
  }
  const dateLabelOptions = this.owner.options.style.dateLabel;
  const currentDivisions = {
    minor: this.unitLengthInYears,
    major: this.unitLengthInYears * 10
  };
  for (var i = 0; i < markerTypes.length; i++) {
    const markerType = markerTypes[i];
    const prefixOptions = Object.values(dateLabelOptions[markerType].yearPrefixes);
    this.yearPrefix[markerType] = false;
    prefixOptions.sort(function(a, b) {
      return b.minDivision - a.minDivision;
    });
    for (let j = 0; j < prefixOptions.length; j++) {
      const prefix = prefixOptions[j];
      if (prefix.minDivision <= currentDivisions[markerType]) {
        this.yearPrefix[markerType] = {
          label: prefix.label,
          value: prefix.value
        };
        break;
      }
    }
  }
};
const DEFAULT_ALLOWED_SCHEMES = ["http", "https", "data", "blob"];
function isAllowedScheme(urlString, allowedSchemes = DEFAULT_ALLOWED_SCHEMES) {
  if (typeof urlString !== "string") {
    return false;
  }
  const trimmed = urlString.trim();
  const lower = trimmed.toLowerCase();
  if (lower.startsWith("data:")) {
    return allowedSchemes.includes("data");
  }
  if (lower.startsWith("blob:")) {
    return allowedSchemes.includes("blob");
  }
  try {
    const u = new URL(trimmed, typeof window !== "undefined" ? window.location.href : void 0);
    return allowedSchemes.includes(u.protocol.replace(":", ""));
  } catch (_) {
    return false;
  }
}
__name(isAllowedScheme, "isAllowedScheme");
function isAllowedDataImage(urlString) {
  return /^data:image\//i.test(urlString);
}
__name(isAllowedDataImage, "isAllowedDataImage");
function isAllowedOrigin(urlString, allowedOrigins) {
  if (!Array.isArray(allowedOrigins) || allowedOrigins.length === 0) {
    return true;
  }
  try {
    const u = new URL(urlString, typeof window !== "undefined" ? window.location.href : void 0);
    const origin = u.origin.toLowerCase();
    const host = u.hostname.toLowerCase();
    for (const raw of allowedOrigins) {
      if (typeof raw !== "string") {
        continue;
      }
      const allowed = raw.trim().toLowerCase();
      if (allowed.includes("://")) {
        try {
          const allowedOrigin = new URL(allowed).origin.toLowerCase();
          if (origin === allowedOrigin) {
            return true;
          }
        } catch {
        }
        continue;
      }
      if (allowed.startsWith("*.") && (host === allowed.slice(2) || host.endsWith(`.${allowed.slice(2)}`))) {
        return true;
      }
      if (allowed.startsWith(".") && (host === allowed.slice(1) || host.endsWith(allowed))) {
        return true;
      }
      if (host === allowed || host.endsWith(`.${allowed}`)) {
        return true;
      }
    }
    return false;
  } catch (_) {
    return true;
  }
}
__name(isAllowedOrigin, "isAllowedOrigin");
function sanitizeImageUrl(url, options = {}) {
  if (typeof url !== "string") {
    return null;
  }
  const allowedSchemes = Array.isArray(options.allowedSchemes) && options.allowedSchemes.length ? options.allowedSchemes : DEFAULT_ALLOWED_SCHEMES;
  if (!isAllowedScheme(url, allowedSchemes)) {
    return null;
  }
  const lower = url.trim().toLowerCase();
  if (lower.startsWith("data:")) {
    if (!isAllowedDataImage(lower)) {
      return null;
    }
    return url;
  }
  if (!isAllowedOrigin(url, options.allowedOrigins)) {
    return null;
  }
  return url;
}
__name(sanitizeImageUrl, "sanitizeImageUrl");
function getDevicePixelRatio() {
  const dpr = typeof globalThis !== "undefined" && globalThis.devicePixelRatio || 1;
  if (typeof dpr !== "number" || !isFinite(dpr) || dpr <= 0) {
    return 1;
  }
  return dpr;
}
__name(getDevicePixelRatio, "getDevicePixelRatio");
function resolveDPR(opts) {
  const useNative = opts && opts.dprMode === "native";
  const device = getDevicePixelRatio();
  const auto = useNative ? device : Math.ceil(device);
  const wanted = opts && typeof opts.dpr === "number" && isFinite(opts.dpr) && opts.dpr > 0 ? opts.dpr : auto;
  const max = opts && typeof opts.maxDpr === "number" && isFinite(opts.maxDpr) && opts.maxDpr > 0 ? opts.maxDpr : 4;
  return Math.min(max, Math.max(1, wanted));
}
__name(resolveDPR, "resolveDPR");
function setCanvasDPR(canvas, cssWidth, cssHeight, ctx, options) {
  const ratio = resolveDPR(options);
  const displayWidth = Math.max(
    1,
    Math.round(cssWidth != null ? cssWidth : canvas.clientWidth || canvas.width || 1)
  );
  const displayHeight = Math.max(
    1,
    Math.round(cssHeight != null ? cssHeight : canvas.clientHeight || canvas.height || 1)
  );
  if (canvas.style) {
    if (canvas.style.width !== `${displayWidth}px`) {
      canvas.style.width = `${displayWidth}px`;
    }
    if (canvas.style.height !== `${displayHeight}px`) {
      canvas.style.height = `${displayHeight}px`;
    }
  }
  const targetWidth = displayWidth * ratio;
  const targetHeight = displayHeight * ratio;
  if (canvas.width !== targetWidth) {
    canvas.width = targetWidth;
  }
  if (canvas.height !== targetHeight) {
    canvas.height = targetHeight;
  }
  const context = ctx || canvas.getContext && canvas.getContext("2d") || null;
  if (context && typeof context.setTransform === "function") {
    context.setTransform(ratio, 0, 0, ratio, 0, 0);
  }
  canvas._dpr = ratio;
  return ratio;
}
__name(setCanvasDPR, "setCanvasDPR");
function applyShadow(ctx, shadow) {
  const dpr = ctx.canvas._dpr || 1;
  ctx.shadowOffsetX = shadow.x * dpr;
  ctx.shadowOffsetY = shadow.y * dpr;
  ctx.shadowBlur = shadow.amount * dpr;
  ctx.shadowColor = shadow.color;
}
__name(applyShadow, "applyShadow");
function isCanvas(el) {
  return el instanceof HTMLCanvasElement || el && el.nodeName === "CANVAS";
}
__name(isCanvas, "isCanvas");
function createCanvas({ width, height, className, style } = {}) {
  const c = document.createElement("canvas");
  if (width != null) {
    c.width = width;
  }
  if (height != null) {
    c.height = height;
  }
  if (className) {
    c.className = className;
  }
  c.style.touchAction = "none";
  if (style) {
    Object.assign(c.style, style);
  }
  return c;
}
__name(createCanvas, "createCanvas");
function append(parent, child) {
  parent?.append ? parent.append(child) : parent.appendChild(child);
  return child;
}
__name(append, "append");
function pageOffset(el) {
  const rect = el.getBoundingClientRect();
  return {
    left: rect.left,
    top: rect.top
  };
}
__name(pageOffset, "pageOffset");
function clearSelection() {
  if (document.selection) {
    document.selection.empty();
  } else if (window.getSelection) {
    window.getSelection().removeAllRanges();
  }
}
__name(clearSelection, "clearSelection");
function getValueOrFunctionResult(value, context, ...args) {
  return typeof value === "function" ? value.call(context, ...args) : value;
}
__name(getValueOrFunctionResult, "getValueOrFunctionResult");
const HAS_POINTER = typeof window !== "undefined" && "onpointerdown" in window;
const MAP = HAS_POINTER ? { down: "pointerdown", move: "pointermove", up: "pointerup", cancel: "pointercancel", leave: "pointerleave" } : { down: "mousedown", move: "mousemove", up: "mouseup", cancel: "mouseleave", leave: "mouseleave" };
function on(el, logicalType, handler, opts) {
  const actual = MAP[logicalType] || logicalType;
  el.addEventListener(actual, handler, opts);
  if (!HAS_POINTER) {
    if (logicalType === "down") {
      el.addEventListener("touchstart", handler, opts);
    }
    if (logicalType === "move") {
      el.addEventListener("touchmove", handler, opts);
    }
    if (logicalType === "up") {
      el.addEventListener("touchend", handler, opts);
      el.addEventListener("touchcancel", handler, opts);
    }
  }
}
__name(on, "on");
function off(el, logicalType, handler, opts) {
  const actual = MAP[logicalType] || logicalType;
  el.removeEventListener(actual, handler, opts);
  if (!HAS_POINTER) {
    if (logicalType === "down") {
      el.removeEventListener("touchstart", handler, opts);
    }
    if (logicalType === "move") {
      el.removeEventListener("touchmove", handler, opts);
    }
    if (logicalType === "up") {
      el.removeEventListener("touchend", handler, opts);
      el.removeEventListener("touchcancel", handler, opts);
    }
  }
}
__name(off, "off");
function getPoint(evt) {
  if (evt.touches && evt.touches[0]) {
    const t = evt.touches[0];
    return { x: t.clientX, y: t.clientY };
  }
  if (evt.changedTouches && evt.changedTouches[0]) {
    const t = evt.changedTouches[0];
    return { x: t.clientX, y: t.clientY };
  }
  return { x: evt.clientX, y: evt.clientY };
}
__name(getPoint, "getPoint");
const _PointerTracker = class _PointerTracker {
  constructor(target, { onStart, onMove, onEnd } = {}) {
    this.target = target;
    this.onStart = onStart;
    this.onMove = onMove;
    this.onEnd = onEnd;
    this.pointers = /* @__PURE__ */ new Map();
    this._handleDown = this._handleDown.bind(this);
    this._handleMove = this._handleMove.bind(this);
    this._handleUp = this._handleUp.bind(this);
    on(target, "down", this._handleDown);
    on(window, "move", this._handleMove);
    on(window, "up", this._handleUp);
    if (HAS_POINTER) {
      on(window, "cancel", this._handleUp);
    }
  }
  destroy() {
    off(this.target, "down", this._handleDown);
    off(window, "move", this._handleMove);
    off(window, "up", this._handleUp);
    if (HAS_POINTER) {
      off(window, "cancel", this._handleUp);
    }
    this.pointers.clear();
  }
  _handleDown(evt) {
    if (HAS_POINTER) {
      this._addOrUpdatePointer(evt);
    } else if (evt.touches) {
      this._syncTouches(evt);
    } else {
      this.pointers.set("mouse", { id: "mouse", x: evt.clientX, y: evt.clientY, type: "mouse" });
    }
    this.onStart && this.onStart(evt, this);
  }
  _handleMove(evt) {
    if (HAS_POINTER) {
      if (this.pointers.has(this._getPointerId(evt))) {
        this._addOrUpdatePointer(evt);
      }
    } else if (evt.touches) {
      this._syncTouches(evt);
    } else if (this.pointers.has("mouse")) {
      const p = this.pointers.get("mouse");
      p.x = evt.clientX;
      p.y = evt.clientY;
    }
    this.onMove && this.onMove(evt, this);
  }
  _handleUp(evt) {
    if (HAS_POINTER) {
      this.pointers.delete(this._getPointerId(evt));
    } else if (evt.changedTouches) {
      for (const t of evt.changedTouches) {
        this.pointers.delete(t.identifier);
      }
      if (!evt.touches || evt.touches.length === 0) {
        this.pointers.delete("mouse");
      }
    } else {
      this.pointers.delete("mouse");
    }
    this.onEnd && this.onEnd(evt, this);
  }
  _getPointerId(evt) {
    return evt.pointerId != null ? evt.pointerId : "mouse";
  }
  _addOrUpdatePointer(evt) {
    this.pointers.set(this._getPointerId(evt), {
      id: this._getPointerId(evt),
      x: evt.clientX,
      y: evt.clientY,
      type: evt.pointerType || "mouse"
    });
  }
  _syncTouches(evt) {
    this.pointers.clear();
    for (const t of evt.touches) {
      this.pointers.set(t.identifier, {
        id: t.identifier,
        x: t.clientX,
        y: t.clientY,
        type: "touch"
      });
    }
  }
  /**
   * Convenience: an array snapshot of current pointer states.
   */
  get list() {
    return Array.from(this.pointers.values());
  }
};
__name(_PointerTracker, "PointerTracker");
let PointerTracker = _PointerTracker;
function getPrimary(tracker) {
  return tracker.list[0] || null;
}
__name(getPrimary, "getPrimary");
function getPinchCentre(tracker) {
  const pts = tracker.list;
  if (pts.length === 0) {
    return null;
  }
  if (pts.length === 1) {
    return { x: pts[0].x, y: pts[0].y };
  }
  return {
    x: (pts[0].x + pts[1].x) / 2,
    y: (pts[0].y + pts[1].y) / 2
  };
}
__name(getPinchCentre, "getPinchCentre");
function getPinchDistance(tracker) {
  const pts = tracker.list;
  if (pts.length < 2) {
    return 0;
  }
  const dx = pts[0].x - pts[1].x;
  const dy = pts[0].y - pts[1].y;
  return Math.hypot(dx, dy);
}
__name(getPinchDistance, "getPinchDistance");
const ARTICLE_DATA_DEFAULTS = {
  from: {
    precision: PRECISION_DAY
  },
  to: {
    precision: PRECISION_DAY
  },
  rank: 0,
  starred: false,
  hidePeriodLine: false,
  hiddenByFilter: false
};
const DEFAULT_STYLE = {
  width: 150,
  color: "#e9e9e9",
  backgroundColor: "#fff",
  topRadius: 3,
  // portrait card layout only
  maxImageHeight: 400,
  // Deprecated, use image.maxHeight instead
  image: {
    shape: "natural",
    margin: 0,
    maxHeight: 400,
    borderRadius: 0
  },
  header: {
    height: 50,
    // portrait card layout only
    text: {
      font: "normal 14px 'Segoe UI'",
      align: "left",
      baseline: "middle",
      margin: 10,
      color: "#333",
      lineHeight: 18,
      numberOfLines: 2,
      offsetY: 0
    }
  },
  subheader: {
    height: 30,
    // portrait card layout only
    color: "#555",
    // portrait card layout only
    text: {
      font: "normal 11px 'Segoe UI'",
      color: "#eee",
      align: "left",
      baseline: "middle",
      margin: 10,
      lineHeight: 6,
      offsetY: 0
    }
  },
  shadow: {
    x: 0,
    y: 0,
    amount: 0,
    color: "#000"
  },
  border: {
    color: "#ddd",
    width: 1
  },
  connectorLine: {
    visible: true,
    offsetX: 18,
    offsetY: -20,
    thickness: 1,
    arrow: {
      width: 16,
      height: 45
    }
  },
  star: {
    width: 16,
    margin: 3
  }
};
const DEFAULT_HOVER_STYLE = {
  color: "#a6c6e2"
};
const DEFAULT_ACTIVE_STYLE = {
  color: "#337ab7",
  header: {
    text: {
      color: "#fff"
    }
  },
  subheader: {
    color: "#333"
  },
  shadow: {
    x: 3,
    y: 3,
    amount: 5,
    color: "#333"
  },
  border: {
    width: 2,
    color: "#2e6da4"
  },
  connectorLine: {
    thickness: 2
  }
};
const TIME_BAND_DEFAULT_STYLE = {
  backgroundColor: "rgba(200, 200, 200, 0.25)",
  border: {
    color: "rgba(120, 120, 120, 0.25)",
    width: 1
  },
  text: {
    font: "normal 16px Calibri",
    color: "#555",
    align: "left",
    baseline: "bottom",
    verticalAlign: "bottom",
    margin: 4,
    offsetY: 0
  }
};
const ENGINE_DEFAULTS = {
  width: 1e3,
  height: 500,
  verticalOffset: 40,
  enableUserControl: true,
  enableCursor: true,
  canvas: {
    dpr: "auto",
    dprMode: "stable",
    maxDpr: 3
  },
  zoom: {
    initial: 34,
    minimum: 0,
    maximum: 123,
    wheelStep: 0.1,
    wheelSpeed: 3,
    allowCtrlWheel: false,
    wheelMode: "auto",
    proportionalGain: 2,
    proportionalExponent: 1.1,
    ratio: 0.8,
    unitSize: {
      // todo: This effects 2 things and needs to be adjusted for separate
      // control. Currently is size of day unit at zoom = 0 AND maximum
      // density region size
      initial: 200,
      showMinorLabels: 48,
      minimum: 8
    }
  },
  initialDate: {
    year: 1990,
    month: 1,
    day: 1
  },
  shiftBceDates: false,
  draggingVicinity: true,
  style: {
    mainLine: {
      visible: true,
      position: "bottom",
      size: 8,
      showDateIndicators: true
    },
    draggingHighlight: {
      visible: true,
      color: "rgba(237, 247, 255, 0.5)",
      area: {
        up: 0,
        down: "edge"
      }
    },
    marker: {
      minor: {
        height: 12,
        extend: false,
        color: "#6097f2",
        futureColor: "#ccc"
      },
      major: {
        height: 30,
        extend: false,
        color: "#0c3a88",
        futureColor: "#ccc"
      }
    },
    dateLabel: {
      minor: {
        font: "normal 10px Calibri",
        color: "#333",
        futureColor: "#ccc",
        textAlign: "start",
        offset: {
          x: 4,
          y: 0
        },
        bceText: "",
        thousandsSeparator: ",",
        yearPrefixes: {
          ka: { label: "ka", value: 1e3, minDivision: 1e3 },
          Ma: { label: "Ma", value: 1e6, minDivision: 1e5 },
          Ga: { label: "Ga", value: 1e9, minDivision: 1e8 }
        }
      },
      major: {
        font: "normal 16px Calibri",
        color: "#000",
        futureColor: "#ccc",
        textAlign: "start",
        offset: {
          x: 4,
          y: 0
        },
        bceText: " ʙᴄᴇ",
        thousandsSeparator: ",",
        yearPrefixes: {
          ka: { label: "ka", value: 1e3, minDivision: 1e5 },
          Ma: { label: "Ma", value: 1e6, minDivision: 1e6 },
          Ga: { label: "Ga", value: 1e9, minDivision: 1e9 }
        }
      }
    },
    cursor: {
      timeline: { hover: "default", dragging: "e-resize" },
      clickable: "pointer",
      article: { hoverDraggable: "move", dragging: "move" }
    }
  },
  timeBand: {
    visible: true,
    // Reserve extra space beneath the main line when time bands are in use
    // (keeps existing verticalOffset for timelines without time bands)
    reserveSpace: true,
    reserveSpacePixels: 20,
    area: {
      up: 0,
      down: "edge"
    },
    defaultStyle: TIME_BAND_DEFAULT_STYLE,
    data: []
  },
  image: {
    maxConcurrent: 6,
    maxCacheBytes: 64 * 1024 * 1024,
    requireCORS: false,
    decodeMode: "auto",
    sanitizer: {
      allowedSchemes: ["http", "https", "data", "blob"]
    }
  },
  article: {
    density: DENSITY_ALL,
    draggable: true,
    distanceToMainLine: 350,
    collectOngoing: false,
    autoStacking: {
      active: true,
      rowSpacing: 50,
      range: RANGE_ALL,
      fitToHeight: true,
      topGap: 10
    },
    periodLine: {
      spacing: 4,
      thickness: 10,
      stacking: {
        sorter: ARTICLE_FROM_SORTER,
        reverseOrder: false
      }
    },
    animation: {
      fade: {
        active: true,
        duration: 1500,
        easing: "swing"
      },
      move: {
        active: true,
        duration: 1500,
        easing: "swing"
      }
    },
    star: {
      visible: true
    },
    defaultData: { ...ARTICLE_DATA_DEFAULTS },
    defaultCardLayout: "portrait",
    defaultStyle: { ...DEFAULT_STYLE },
    defaultHoverStyle: { ...DEFAULT_HOVER_STYLE },
    defaultActiveStyle: { ...DEFAULT_ACTIVE_STYLE },
    layoutStyles: {}
  }
};
function handleDeprecatedOptions(inputOptions) {
  if (!inputOptions) {
    return inputOptions;
  }
  const processedOptions = deepMerge({}, inputOptions);
  if (inputOptions.article?.periodLine?.defaultHide !== void 0) {
    Logger.warn(
      "DEPRECATION WARNING: article.periodLine.defaultHide is deprecated. Use article.defaultData.hidePeriodLine instead."
    );
    if (!processedOptions.article) {
      processedOptions.article = {};
    }
    if (!processedOptions.article.defaultData) {
      processedOptions.article.defaultData = {};
    }
    processedOptions.article.defaultData.hidePeriodLine = inputOptions.article.periodLine.defaultHide;
  }
  const styleKeys = ["defaultStyle", "defaultHoverStyle", "defaultActiveStyle"];
  styleKeys.forEach((styleKey) => {
    if (inputOptions.article?.[styleKey]?.maxImageHeight !== void 0) {
      Logger.warn(
        `DEPRECATION WARNING: article.${styleKey}.maxImageHeight is deprecated. Use article.${styleKey}.image.maxHeight instead.`
      );
      if (!processedOptions.article) {
        processedOptions.article = {};
      }
      if (!processedOptions.article[styleKey]) {
        processedOptions.article[styleKey] = {};
      }
      if (!processedOptions.article[styleKey].image) {
        processedOptions.article[styleKey].image = {};
      }
      processedOptions.article[styleKey].image.maxHeight = inputOptions.article[styleKey].maxImageHeight;
    }
  });
  if (inputOptions.onSave !== void 0) {
    Logger.warn(
      'DEPRECATION WARNING: onSave is deprecated. Use options.on["timeline-state-change"] instead.'
    );
    if (!processedOptions.on) {
      processedOptions.on = {};
    }
    if (!processedOptions.on["timeline-state-change"]) {
      const legacyOnSave = inputOptions.onSave;
      if (typeof legacyOnSave === "function") {
        processedOptions.on["timeline-state-change"] = function(payload) {
          legacyOnSave.call(this, payload);
        };
      }
    }
  }
  if (inputOptions.onArticleClick !== void 0) {
    Logger.warn(
      'DEPRECATION WARNING: onArticleClick is deprecated. Use options.on["article-click"] for click events, or options.on["article-select"] for selection by any means.'
    );
    if (!processedOptions.on) {
      processedOptions.on = {};
    }
    if (!processedOptions.on["article-click"]) {
      const legacyOnArticleClick = inputOptions.onArticleClick;
      if (typeof legacyOnArticleClick === "function") {
        processedOptions.on["article-click"] = function(article, evt) {
          legacyOnArticleClick.call(this, article);
        };
      }
    }
  }
  if (inputOptions.onArticleDoubleClick !== void 0) {
    Logger.warn(
      'DEPRECATION WARNING: onArticleDoubleClick is deprecated. Use options.on["article-dblclick"] instead.'
    );
    if (!processedOptions.on) {
      processedOptions.on = {};
    }
    if (!processedOptions.on["article-dblclick"]) {
      const legacyOnArticleDoubleClick = inputOptions.onArticleDoubleClick;
      if (typeof legacyOnArticleDoubleClick === "function") {
        processedOptions.on["article-dblclick"] = function(article, evt) {
          legacyOnArticleDoubleClick.call(this, article);
        };
      }
    }
  }
  if (inputOptions.onRedraw !== void 0) {
    Logger.warn(
      'DEPRECATION WARNING: onRedraw is deprecated. Use options.on["timeline-render-end"] instead.'
    );
    if (!processedOptions.on) {
      processedOptions.on = {};
    }
    if (!processedOptions.on["timeline-render-end"]) {
      const legacyOnRedraw = inputOptions.onRedraw;
      if (typeof legacyOnRedraw === "function") {
        processedOptions.on["timeline-render-end"] = function(ctx) {
          legacyOnRedraw.call(this, ctx);
        };
      }
    }
    delete processedOptions.onRedraw;
  }
  return processedOptions;
}
__name(handleDeprecatedOptions, "handleDeprecatedOptions");
const DEFAULT_OPTIONS = deepMerge({}, ENGINE_DEFAULTS);
function Timeline(container, inputOptions) {
  const processedInputOptions = handleDeprecatedOptions(inputOptions);
  this.options = deepMerge({}, DEFAULT_OPTIONS, processedInputOptions);
  if (isCanvas(container)) {
    this.canvas = container;
  } else {
    this.canvas = createCanvas();
    append(container, this.canvas);
  }
  if (this.canvas && this.canvas.style) {
    if (this.options.width != null) {
      this.canvas.style.width = `${this.options.width}px`;
    }
    if (this.options.height != null) {
      this.canvas.style.height = `${this.options.height}px`;
    }
  }
  this.canvasContext = this.canvas.getContext("2d");
  this.canvasDpr = setCanvasDPR(
    this.canvas,
    this.options.width,
    this.options.height,
    this.canvasContext,
    this.options.canvas
  );
  this.fontWatcher = new FontWatcher((loadedFont) => {
    this.forLoadedArticles((article) => article.invalidateCaches());
    this.requestRedraw();
  });
  const ctx = this.canvasContext;
  const originalMeasureText = ctx.measureText.bind(ctx);
  ctx.measureText = (text) => {
    this.fontWatcher.use(ctx.font);
    return originalMeasureText(text);
  };
  this.width = this.canvas.clientWidth || this.options.width;
  this.top = this.options.height - this._getEffectiveVerticalOffset();
  this.repositionWindow = 0;
  this.uniqueId = `tl${(/* @__PURE__ */ new Date()).getTime()}`;
  this.title = "My timeline";
  this.ownerId = void 0;
  this.cursor = "default";
  this.mouseoverArticle = null;
  this.isDragging = false;
  this.draggingArticle = null;
  this.dragStartX = 0;
  this.isPanning = false;
  this.isPinching = false;
  this.isAnimating = false;
  this.isAnimatingArticles = false;
  this.isCustomAnimating = false;
  this.animation = {
    redrawFunction: false,
    defaultRedrawFunction: this.repositionRedraw,
    dragRedrawFunction: this.defaultRedraw,
    pan: null,
    zoom: null
  };
  this.lastAnimatingArticle = {
    id: null,
    endTime: 0
  };
  this.topRow = 0;
  this.loadingHttpRequests = [];
  this.articles = [];
  this.timeBands = [];
  this.redrawRequests = {
    default: false,
    reposition: false
  };
  this.handlers = {};
  if (this.options.on) {
    this.onMultiple(this.options.on);
  }
  this._isInitialized = false;
  const zoom = this.options.zoom, startDate = this.getDmyFromInput(new Dmy(this.options.initialDate));
  this.timescaleManager = new TimescaleManager(this, zoom);
  this.timescaleManager.setUnitLevels();
  this.timescaleManager.addZoomChangedHandler(this.zoomChanged, this);
  this.timescaleManager.setZoom(zoom.initial);
  this.timescaleManager.setStartDate(startDate);
  if (this.options.enableUserControl) {
    this.enableZoomByWheel();
    this.enableDragging();
  }
  this.groups = { level: -1, periods: [] };
  const imageOptions = this.options.image || {};
  this.imageLoader = new ImageLoader({
    maxConcurrent: imageOptions.maxConcurrent,
    maxCacheBytes: imageOptions.maxCacheBytes,
    requireCORS: imageOptions.requireCORS,
    decodeMode: imageOptions.decodeMode
  });
  if (this.options.timeBand && Array.isArray(this.options.timeBand.data) && this.options.timeBand.data.length > 0) {
    if (typeof this.addTimeBands === "function") {
      this.addTimeBands(this.options.timeBand.data);
    }
  }
  this.requestRedraw();
  this._isInitialized = true;
}
__name(Timeline, "Timeline");
Timeline.prototype.setTitle = function(title) {
  this.title = title;
  this._emitTimelineStateChange();
};
Timeline.prototype.getWidth = function() {
  return this.canvas.clientWidth || this.options.width;
};
Timeline.prototype.getCanvasDpr = function() {
  return this.canvasDpr || 1;
};
Timeline.prototype.isInVicinity = function(event, vicinityParameters, relativePosition) {
  vicinityParameters = getValueOrFunctionResult(vicinityParameters, this, event, relativePosition);
  if (typeof vicinityParameters === "boolean") {
    return vicinityParameters;
  }
  const pos = relativePosition || this.getRelativePosition(event);
  return pos.top > this.top - vicinityParameters.up && pos.top < this.top + vicinityParameters.down;
};
Timeline.prototype.getPixel = function(dmy, drawCycleContext) {
  let cache;
  const key = dmy.toKeyString();
  if (drawCycleContext) {
    cache = drawCycleContext.tokens;
    if (cache.hasOwnProperty(key)) {
      return cache[key];
    }
  } else {
    cache = {};
  }
  this.getWidth();
  const x = this.repositionWindow;
  const token = this.timescaleManager.startToken;
  return cache[key] = this.timescaleManager.getPixelsBetween(token.value, dmy) + x;
};
Timeline.prototype.getRelativePosition = function(evt) {
  const { x: clientX, y: clientY } = getPoint(evt);
  const rect = this.canvas.getBoundingClientRect();
  return {
    left: clientX - rect.left,
    top: clientY - rect.top
  };
};
Timeline.prototype.updateCursor = function(event) {
  const oldCursor = this.cursor;
  const newCursor = this.cursor = this.getCursor(event);
  if (oldCursor !== newCursor) {
    this.canvas.style.cursor = newCursor;
  }
};
Timeline.prototype.getCursor = function(event) {
  const cursor = this.options.style.cursor;
  if (this.isDragging) {
    return cursor.timeline.dragging;
  }
  const pos = this.getRelativePosition(event);
  if (this.draggingArticle) {
    return this.draggingArticle.getCursor(pos);
  }
  if (!this.options.disableBranding && (this._isInsideHistropediaJSLink(pos) || this._isInsideTermsLink(pos))) {
    return cursor.clickable;
  }
  if (this.mouseoverArticle !== null) {
    return this.mouseoverArticle.getCursor(pos);
  }
  return cursor.timeline.hover;
};
Timeline.prototype.onRedraw = function(handler) {
  Logger.warn(
    'DEPRECATION WARNING: timeline.onRedraw(handler) is deprecated. Use timeline.on("timeline-render-end", handler) instead.'
  );
  if (typeof this.on !== "function") {
    return;
  }
  this.on("timeline-render-end", handler);
};
Timeline.prototype.zoomChanged = function() {
  let oldRegionId;
  if (this.currentDensitySetting) {
    oldRegionId = this.currentDensitySetting.region;
  }
  this.updateCurrentDensitySetting();
  if (oldRegionId !== this.currentDensitySetting.region) {
    this.updateArticlesGroupIndex();
  }
};
Timeline.prototype.updateCurrentDensitySetting = function() {
  for (let i = 0; i < DENSITY_SETTINGS.length; i++) {
    const densitySetting = DENSITY_SETTINGS[i];
    if (this.timescaleManager.zoom >= densitySetting.zoom.from && this.timescaleManager.zoom < densitySetting.zoom.to) {
      this.currentDensitySetting = densitySetting;
      break;
    }
  }
};
Timeline.prototype.calculateEndToken = function() {
  const width = this.getWidth();
  let x = this.repositionWindow;
  const startToken = this.timescaleManager.startToken;
  let token = startToken;
  let endToken;
  do {
    endToken = token;
    token = this.timescaleManager.getNext(token);
    x += token.length;
  } while (x < width);
  return endToken;
};
Timeline.prototype.getDensityPick = function() {
  switch (this.options.article.density) {
    case DENSITY_LOW:
      return this.currentDensitySetting.low;
    case DENSITY_MEDIUM:
      return this.currentDensitySetting.medium;
    case DENSITY_HIGH:
      return this.currentDensitySetting.high;
    case DENSITY_ALL:
      return this.currentDensitySetting.all;
  }
  Logger.error(`Unknown density selector:${val}`);
};
Timeline.prototype.invoke = function(method, callbacks, params) {
  if (callbacks.hasOwnProperty(method)) {
    callbacks[method].call(this, params);
  }
};
Timeline.prototype.forLoadedArticles = function(f) {
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.isDataLoaded) {
      f.call(this, article);
    }
  }
};
Timeline.prototype.forVisibleArticles = function(f) {
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.isDataLoaded && article.isVisible) {
      f.call(this, article);
    }
  }
};
Timeline.prototype.forInRangeArticles = function(f) {
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.isDataLoaded && (article.isInRange || article.isFading)) {
      f.call(this, article);
    }
  }
};
Timeline.prototype.enqueueImageLoad = function(article) {
  let url = getPropertyFromData(article.data, "imageUrl");
  if (!url) {
    if (typeof article._closeImage === "function") {
      try {
        article._closeImage({ keepState: false, skipRedraw: true });
      } catch (_) {
      }
    }
    article.image = null;
    article.imageLoaded = false;
    article._closeImage = null;
    article._loadedImageKey = null;
    article._pendingImageKey = null;
    return;
  }
  const { sanitizer, customSanitizer } = this.options.image;
  if (typeof customSanitizer === "function") {
    try {
      url = customSanitizer(url, sanitizer);
    } catch (_) {
      url = null;
    }
  } else {
    url = sanitizeImageUrl(url, sanitizer);
  }
  if (!url) {
    if (typeof article._closeImage === "function") {
      try {
        article._closeImage({ keepState: false, skipRedraw: true });
      } catch (_) {
      }
    }
    article.image = null;
    article.imageLoaded = false;
    article._closeImage = null;
    article._loadedImageKey = null;
    article._pendingImageKey = null;
    return;
  }
  const spec = this._getArticleImageTargetSpec(article);
  const normalizedDpr = spec && Number.isFinite(spec.dpr) && spec.dpr > 0 ? Math.round(Math.max(1, spec.dpr) * 1e3) / 1e3 : 1;
  const key = `img:${url}:${spec.layout}:${spec.shape}:${spec.targetW || 0}x${spec.targetH || 0}@${normalizedDpr}`;
  if (article._loadedImageKey === key && article.imageLoaded && article.image) {
    return;
  }
  if (article._pendingImageKey === key && typeof article._imageCancel === "function") {
    return;
  }
  if (article._pendingImageKey && article._pendingImageKey !== key && typeof article._imageCancel === "function") {
    try {
      article._imageCancel();
    } catch (_) {
    }
    article._imageCancel = null;
  }
  if (!(article.imageLoaded && article.image)) {
    article.imageLoaded = false;
  }
  article._pendingImageKey = key;
  const cancel = this.imageLoader.enqueue(
    key,
    url,
    (imgLike, tainted, kind, close, release) => {
      if (typeof article._closeImage === "function") {
        try {
          article._closeImage({ keepState: false, skipRedraw: true });
        } catch (_) {
        }
      }
      let detach = null;
      if (typeof release === "function") {
        detach = release;
      } else if (typeof close === "function") {
        detach = /* @__PURE__ */ __name(function() {
          try {
            close();
          } catch (_) {
          }
        }, "detach");
      }
      article.image = imgLike;
      article.imageLoaded = true;
      article._loadedImageKey = key;
      article._pendingImageKey = null;
      article._imageCancel = null;
      article._closeImage = detach;
      if (article._closeImage && article._closeImage._key == null && typeof release === "function") {
        article._closeImage._key = key;
        article._closeImage._article = article;
      }
      if (typeof article.updateCachedSize === "function") {
        article.updateCachedSize();
      }
      this.requestRedraw(this.redraw);
    },
    { targetW: spec.targetW, targetH: spec.targetH, shape: spec.shape, article }
  );
  article._imageCancel = cancel;
};
Timeline.prototype._getArticleImageTargetSpec = function(article) {
  const layout = article._getCurrentCardLayoutName();
  const style = article._getCurrentStyle();
  const imageStyle = style && style.image ? style.image : {};
  const shape = imageStyle.shape || (layout === "portrait" ? "square" : "square");
  let cssTargetW = null, cssTargetH = null;
  if (layout === "landscape") {
    const margin = imageStyle.margin || 0;
    const imageSize = Math.max(1, (style.height || 0) - margin * 2);
    cssTargetW = imageSize;
    cssTargetH = imageSize;
  } else if (layout === "portrait") {
    const margin = imageStyle.margin || 0;
    const borderWidth = 0;
    const availableWidth = Math.max(1, (style.width || 0) - borderWidth - margin * 2);
    if (shape === "square" || shape === "circle") {
      cssTargetW = availableWidth;
      cssTargetH = availableWidth;
    } else {
      cssTargetW = availableWidth;
    }
  } else {
    if (style && typeof style.width === "number") {
      cssTargetW = style.width;
    }
  }
  const rawDpr = typeof this.getCanvasDpr === "function" ? this.getCanvasDpr() : Number(this.canvasDpr);
  const dpr = Number.isFinite(rawDpr) && rawDpr > 0 ? rawDpr : 1;
  const scaleForDpr = /* @__PURE__ */ __name((value) => {
    if (typeof value !== "number" || !Number.isFinite(value) || value <= 0) {
      return null;
    }
    return Math.max(1, Math.round(value * dpr));
  }, "scaleForDpr");
  const targetW = scaleForDpr(cssTargetW);
  const targetH = scaleForDpr(cssTargetH);
  return { layout, targetW, targetH, shape, dpr };
};
Timeline.prototype.setStartDate = function(dmy, pixelOffset) {
  var pixelOffset = pixelOffset || 0;
  if (typeof dmy === "string") {
    dmy = Dmy.fromString(dmy);
  }
  dmy = this.getDmyFromInput(dmy);
  const dateFraction = this.timescaleManager.setStartDate(dmy);
  this.repositionWindow = dateFraction;
  if (pixelOffset) {
    this.updateFromByPixels(-pixelOffset);
  }
  this.requestRedraw();
  this._emitTimelineStateChange();
};
Timeline.prototype.getZoom = function() {
  return this.timescaleManager.zoom;
};
Timeline.prototype.setCentreDate = function(dmy, pixelOffset) {
  this.setStartDate(dmy, this.options.width / 2 + pixelOffset);
};
Timeline.prototype.setOption = function(option, value) {
  if (typeof option === "string") {
    const selectedOption = getPropertyFromData(this.options, option);
    if (typeof value === "undefined") {
      return selectedOption;
    }
    option = buildObjectFromPath(option, value);
  }
  deepMerge(this.options, option);
  const sizeChanged = option.width || option.height;
  if (sizeChanged) {
    this.setSize(this.options.width, this.options.height);
  }
  const canvasDprChanged = existsInData(option, "canvas.dpr") || existsInData(option, "canvas.dprMode") || existsInData(option, "canvas.maxDpr");
  if (!sizeChanged && canvasDprChanged) {
    this.canvasDpr = setCanvasDPR(
      this.canvas,
      this.options.width,
      this.options.height,
      this.canvasContext,
      this.options.canvas
    );
  }
  if (typeof option.verticalOffset === "number") {
    this.top = this.options.height - this._getEffectiveVerticalOffset();
  }
  const timeBandsSpaceChanged = existsInData(option, "timeBand.visible") || existsInData(option, "timeBand.reserveSpace") || existsInData(option, "timeBand.reserveSpacePixels");
  if (timeBandsSpaceChanged) {
    this.top = this.options.height - this._getEffectiveVerticalOffset();
  }
  const styleChanged = existsInData(option, "article.defaultStyle"), activeStyleChanged = existsInData(option, "article.defaultActiveStyle"), hoverStyleChanged = existsInData(option, "article.defaultHoverStyle");
  const currentCardLayout = this._getCurrentCardLayoutName();
  const cardLayoutStyleChanged = existsInData(option, `article.layoutStyles.${currentCardLayout}`);
  const defaultCardLayoutChanged = existsInData(option, "article.defaultCardLayout");
  if (styleChanged || activeStyleChanged || hoverStyleChanged || cardLayoutStyleChanged || defaultCardLayoutChanged) {
    this.forLoadedArticles((article) => {
      article.initialiseStyles(article.data);
      article.invalidateCaches();
    });
  }
  const timeBandsDefaultStyleChanged = existsInData(option, "timeBand.defaultStyle");
  if (timeBandsDefaultStyleChanged && Array.isArray(this.timeBands) && this.timeBands.length > 0) {
    const defaultBandStyle = this.options.timeBand && this.options.timeBand.defaultStyle ? this.options.timeBand.defaultStyle : {};
    for (let i = 0; i < this.timeBands.length; i++) {
      const band = this.timeBands[i];
      const bandDataStyle = band && band.data && band.data.style ? band.data.style : {};
      band.style = deepMerge({}, defaultBandStyle, bandDataStyle);
    }
  }
  this.requestRedraw();
};
Timeline.prototype.setSize = function(width, height) {
  if (this.canvas && this.canvas.style) {
    if (typeof width === "number") {
      this.canvas.style.width = `${width}px`;
    }
    if (typeof height === "number") {
      this.canvas.style.height = `${height}px`;
    }
  }
  this.options.width = width;
  this.options.height = height;
  this.canvasDpr = setCanvasDPR(
    this.canvas,
    width,
    height,
    this.canvasContext,
    this.options.canvas
  );
  this.width = this.canvas.clientWidth || width;
  this.top = height - this._getEffectiveVerticalOffset();
  this.requestRedraw();
};
Timeline.prototype._getEffectiveVerticalOffset = function() {
  const base = this.options.verticalOffset || 0;
  const tb = this.options.timeBand || {};
  const hasLoadedBands = Array.isArray(this.timeBands) && this.timeBands.length > 0;
  const reserve = !!tb.reserveSpace;
  const extra = reserve && tb.visible && hasLoadedBands ? tb.reserveSpacePixels || 0 : 0;
  return base + extra;
};
Timeline.prototype.generateDensitySettings = function() {
  const zoomRatio = this.timescaleManager.zoomOptions.ratio;
  Logger.log(this.timescaleManager);
  const newSettings = [];
  const halfZoom = Math.round(Math.log(0.5) / Math.log(zoomRatio) * 100) / 100;
  for (let i = 0; i < 19; i++) {
    const nextRegion = {
      region: i + 1,
      zoom: { from: i * halfZoom, to: (i + 1) * halfZoom },
      low: 1,
      medium: 2,
      high: 3,
      all: 25,
      step: { months: 0, days: Math.pow(2, i) }
    };
    newSettings.push(nextRegion);
  }
  Logger.log(JSON.stringify(newSettings));
};
Timeline.prototype.updateArticlesGroupIndex = function() {
  this.forLoadedArticles(function(article) {
    article.groupIndex = this.calculateGroupIndex(article.period.from);
  });
};
Timeline.prototype.updateVisibleArticlesOfGroups = function(drawCycleContext) {
  this.groups = {};
  const groupIndexExtension = this.options.article.autoStacking.range == RANGE_SCREEN ? 1 : 20;
  const leftmostGroupIndex = this.calculateGroupIndex(drawCycleContext.tokens.start) - groupIndexExtension;
  const rightmostGroupIndex = this.calculateGroupIndex(drawCycleContext.tokens.end) + groupIndexExtension;
  this.forLoadedArticles(function(article) {
    article.isVisibleInGroup = false;
  });
  for (let index = leftmostGroupIndex; index <= rightmostGroupIndex; index++) {
    this.groups[index] = this.getArticlesInGroup(index, leftmostGroupIndex, rightmostGroupIndex).map(function(a) {
      a.isVisibleInGroup = true;
      return a.id;
    });
  }
};
const STARRED_INCREASE_CONSTANT = 1e7;
const ACTIVE_INCREASE_CONSTANT = 2e7;
Timeline.prototype.getArticlesInGroup = function(index, leftmostGroupIndex, rightmostGroupIndex) {
  function getArticleEffectiveRank(article) {
    let effectiveRank = article.rank;
    if (article.isActive) {
      effectiveRank += ACTIVE_INCREASE_CONSTANT;
    } else {
      if (article.isStarred) {
        effectiveRank += STARRED_INCREASE_CONSTANT;
      }
    }
    return effectiveRank;
  }
  __name(getArticleEffectiveRank, "getArticleEffectiveRank");
  const pick = this.getDensityPick();
  const topArticles = [];
  let minRankIndex = 0;
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (!article.isDataLoaded || article.isHiddenByFilter) {
      continue;
    }
    const belongsToThisGroup = clamp(article.groupIndex, leftmostGroupIndex, rightmostGroupIndex) === index;
    if (!belongsToThisGroup) {
      continue;
    }
    article.effectiveRank = getArticleEffectiveRank(article);
    if (topArticles.length < pick) {
      topArticles.push(article);
      if (article.effectiveRank < topArticles[minRankIndex].effectiveRank) {
        minRankIndex = topArticles.length - 1;
      }
      continue;
    }
    if (article.effectiveRank > topArticles[minRankIndex].effectiveRank) {
      topArticles[minRankIndex] = article;
      minRankIndex = findMinIndex(topArticles, "effectiveRank");
    }
  }
  return topArticles;
};
Timeline.prototype.calculateGroupIndex = function(date) {
  if (this.timescaleManager.unit >= ZOOM_MONTH && this.currentDensitySetting.step.months !== 0) {
    var g = date.year * 12 + (date.month - 1);
    return Math.floor(g / this.currentDensitySetting.step.months);
  }
  var g = date.year * 372 + (date.month - 1) * 31 + date.day;
  if (this.currentDensitySetting.step.days === 0) {
    return Math.floor(g / (this.currentDensitySetting.step.months * 30));
  }
  return Math.floor(g / this.currentDensitySetting.step.days);
};
Timeline.prototype.canBeVisibleInGroup = function(article, startToken, endToken) {
  if (article.isActive) {
    return true;
  }
  startToken = startToken || this.timescaleManager.startToken;
  endToken = endToken || this.calculateEndToken();
  const leftmostGroupIndex = this.calculateGroupIndex(startToken.value) - 1;
  const rightmostGroupIndex = this.calculateGroupIndex(endToken.value) + 1;
  const effectiveArticleGroupIndex = clamp(article.groupIndex, leftmostGroupIndex, rightmostGroupIndex);
  if (!this.groups.hasOwnProperty(effectiveArticleGroupIndex)) {
    return false;
  }
  return this.groups[effectiveArticleGroupIndex].indexOf(article.id) >= 0;
};
Timeline.prototype._drawBranding = function(ctx) {
  this._drawCopyrightLinks(ctx);
};
const LINKS_WIDTH = 117;
const LINKS_HEIGHT = 22;
const LINKS_RIGHT_MARGIN = 0;
const LINKS_BOTTOM_MARGIN = 0;
const LINKS_PADDING_X = 8;
const LINKS_PADDING_Y = 0;
const LINKS_FONT_SIZE = 12;
const LINKS_HISTROPEDIAJS_TEXT = "HistropediaJS";
const LINKS_HISTROPEDIAJS_WIDTH = 75;
const LINKS_TERMS_TEXT = "Terms";
const LINKS_TERMS_WIDTH = 33;
const LINKS_SEPARATOR_WIDTH = 10;
const LINKS_TEXT = `${LINKS_HISTROPEDIAJS_TEXT} | ${LINKS_TERMS_TEXT}`;
Timeline.prototype._drawCopyrightLinks = function(ctx) {
  ctx.beginPath();
  ctx.fillStyle = "rgba(255, 255, 255, 0.8)";
  ctx.fillRect(
    this.width - LINKS_WIDTH - LINKS_RIGHT_MARGIN - LINKS_PADDING_X * 2,
    this.top - Math.floor(this.options.style.mainLine.size / 2) - LINKS_HEIGHT - LINKS_BOTTOM_MARGIN - LINKS_PADDING_Y * 2,
    LINKS_WIDTH + LINKS_PADDING_X * 2,
    LINKS_HEIGHT + LINKS_PADDING_Y * 2
  );
  ctx.textAlign = "left";
  ctx.textBaseline = "middle";
  ctx.fillStyle = "#000000";
  ctx.font = `normal ${LINKS_FONT_SIZE}px "Helvetica Neue", Helvetica, Arial, sans-serif`;
  const textCoords = this._getBrandingTextCoords();
  ctx.fillText(LINKS_TEXT, textCoords.left, textCoords.top, LINKS_WIDTH + LINKS_PADDING_X);
};
Timeline.prototype._getBrandingTextCoords = function() {
  return {
    left: this.width - LINKS_WIDTH - LINKS_RIGHT_MARGIN - LINKS_PADDING_X,
    top: this.top - Math.floor(this.options.style.mainLine.size / 2) - LINKS_HEIGHT - LINKS_BOTTOM_MARGIN + LINKS_FONT_SIZE - LINKS_PADDING_Y
  };
};
Timeline.prototype._isInsideHistropediaJSLink = function(pos) {
  const textCoords = this._getBrandingTextCoords();
  return isInside(pos, {
    left: textCoords.left,
    top: textCoords.top - LINKS_FONT_SIZE / 2,
    width: LINKS_HISTROPEDIAJS_WIDTH,
    height: LINKS_FONT_SIZE
  });
};
Timeline.prototype._isInsideTermsLink = function(pos) {
  const textCoords = this._getBrandingTextCoords();
  return isInside(pos, {
    left: textCoords.left + LINKS_HISTROPEDIAJS_WIDTH + LINKS_SEPARATOR_WIDTH,
    top: textCoords.top - LINKS_FONT_SIZE / 2,
    width: LINKS_TERMS_WIDTH,
    height: LINKS_FONT_SIZE
  });
};
function handleHistropediaJSLinkClick() {
  const w = window.open("https://js.histropedia.com", "_blank", "noopener,noreferrer");
  if (w) {
    w.opener = null;
  }
}
__name(handleHistropediaJSLinkClick, "handleHistropediaJSLinkClick");
function handleTermsLinkClick() {
  const w = window.open("https://js.histropedia.com/licence.html", "_blank", "noopener,noreferrer");
  if (w) {
    w.opener = null;
  }
}
__name(handleTermsLinkClick, "handleTermsLinkClick");
function isInside(pos, rectangle) {
  return pos.left >= rectangle.left && pos.left <= rectangle.left + rectangle.width && pos.top >= rectangle.top && pos.top <= rectangle.top + rectangle.height;
}
__name(isInside, "isInside");
const makeViewportDragPayload = /* @__PURE__ */ __name(({ startToken, offsetX = 0, dx = 0, totalDx = 0 } = {}) => ({
  startToken,
  offsetX,
  dx,
  totalDx
}), "makeViewportDragPayload");
const makePinchPayload = /* @__PURE__ */ __name(({
  centre = null,
  scale = 0,
  zoom = 0,
  distance = 0,
  zoomDelta = 0,
  dx = 0,
  totalZoomDelta = 0,
  pointers = []
} = {}) => ({
  centre,
  scale,
  zoom,
  distance,
  zoomDelta,
  dx,
  totalZoomDelta,
  pointers
}), "makePinchPayload");
const makeWheelPayload = /* @__PURE__ */ __name(({ centre = null, zoom = 0, zoomDelta = 0 } = {}) => ({
  centre,
  zoom,
  zoomDelta
}), "makeWheelPayload");
const makeTimelineClickPayload = /* @__PURE__ */ __name(({ viewport } = {}) => {
  if (!viewport) {
    return { viewport: { x: 0, y: 0 } };
  }
  const { x = viewport.left ?? 0, y = viewport.top ?? 0 } = viewport;
  return { viewport: { x, y } };
}, "makeTimelineClickPayload");
Timeline.prototype.enableDragging = /* @__PURE__ */ __name(function enableDragging() {
  const me = this;
  const clickState = {
    relativePos: null,
    // position at mousedown for click-tolerance test
    time: 0,
    isDoubleClick: false,
    isArticleClick: false,
    isArticleDoubleClick: false,
    isTermsClick: false,
    isHjsClick: false,
    article: null
  };
  const pinch = {
    initial: { distance: 0, zoom: 0 },
    centre: {},
    scale: 1,
    // Track actual applied zoom between frames (after clamping)
    prevActualZoom: 0
  };
  const MOVE_CLICK_TOLERANCE = 2;
  const DOUBLE_CLICK_MS = 500;
  function isMoveWithinTolerance(p1, p2) {
    return Math.abs(p1.left - p2.left) <= MOVE_CLICK_TOLERANCE && Math.abs(p1.top - p2.top) <= MOVE_CLICK_TOLERANCE;
  }
  __name(isMoveWithinTolerance, "isMoveWithinTolerance");
  function relativeCoordsFromCoords(coords) {
    const canvasPage = pageOffset(me.canvas);
    return {
      x: coords.x - canvasPage.left,
      y: coords.y - canvasPage.top
    };
  }
  __name(relativeCoordsFromCoords, "relativeCoordsFromCoords");
  function onPointerStart(evt, tracker) {
    clearSelection();
    if (tracker.list.length >= 2 && !me.isPinching) {
      pinch.centre = relativeCoordsFromCoords(getPinchCentre(tracker));
      pinch.initial.distance = getPinchDistance(tracker);
      pinch.initial.zoom = me.timescaleManager.zoom;
      me.isPinching = true;
      pinch.prevActualZoom = pinch.initial.zoom;
      me.startAnimation();
      me.trigger(
        "zoom-pinch-start",
        makePinchPayload({
          centre: pinch.centre,
          scale: 1,
          distance: pinch.initial.distance,
          zoom: pinch.initial.zoom,
          zoomDelta: 0,
          totalZoomDelta: 0,
          pointers: [...tracker.list]
        }),
        evt
      );
      return;
    }
    const relativePos = clickState.relativePos = me.getRelativePosition(evt);
    if (!me.options.disableBranding) {
      clickState.isHjsClick = me._isInsideHistropediaJSLink(relativePos);
      clickState.isTermsClick = me._isInsideTermsLink(relativePos);
    }
    const now = Date.now();
    clickState.isDoubleClick = now - clickState.time < DOUBLE_CLICK_MS;
    clickState.time = now;
    if (!(clickState.isHjsClick || clickState.isTermsClick)) {
      for (let i = me.articles.length - 1; i >= 0; i--) {
        const article = me.articles[i];
        if (article.isVisible && article.isInside(relativePos)) {
          clickState.isArticleClick = true;
          clickState.article = article;
          if (clickState.isDoubleClick && clickState.article && article.id === clickState.article.id) {
            clickState.isArticleDoubleClick = true;
          }
          if (article.isActive && me.options.article.draggable) {
            me.draggingArticle = article;
            article.startDragging(relativePos, evt);
            return;
          }
          break;
        }
      }
    }
    if (me.draggingArticle === null && me.isInVicinity(evt, me.options.draggingVicinity, relativePos)) {
      me.startDragging(evt);
    }
  }
  __name(onPointerStart, "onPointerStart");
  function onPointerMove(evt, tracker) {
    if (me.isPinching) {
      const zoomRatio = me.timescaleManager.zoomOptions.ratio;
      const previousCentreX = pinch.centre.x;
      pinch.centre = relativeCoordsFromCoords(getPinchCentre(tracker));
      const currentDistance = getPinchDistance(tracker);
      pinch.scale = currentDistance / pinch.initial.distance;
      const candidateTotalZoomDelta = Math.log(pinch.scale) / Math.log(zoomRatio);
      const newZoom = pinch.initial.zoom + candidateTotalZoomDelta;
      const deltaX = previousCentreX - pinch.centre.x;
      me.setZoomByPivotPixel(newZoom, pinch.centre.x, deltaX);
      const actualNewZoom = me.timescaleManager.zoom;
      const totalZoomDelta = actualNewZoom - pinch.initial.zoom;
      const incrementalZoomDelta = actualNewZoom - pinch.prevActualZoom;
      pinch.prevActualZoom = actualNewZoom;
      me.trigger(
        "zoom-pinch",
        makePinchPayload({
          centre: pinch.centre,
          scale: pinch.scale,
          distance: currentDistance,
          zoom: actualNewZoom,
          pointers: [...tracker.list],
          dx: deltaX,
          zoomDelta: incrementalZoomDelta,
          totalZoomDelta
        }),
        evt
      );
    } else if (me.isDragging) {
      me.doDrag(evt);
    } else if (me.draggingArticle !== null) {
      const relativePos = me.getRelativePosition(evt);
      me.draggingArticle.dragging(relativePos, evt);
    } else if (evt.pointerType === "mouse") {
      me.updateMouseoverArticle(evt);
      if (me.mouseoverArticle !== null) {
        me.trigger("article-pointermove", me.mouseoverArticle, evt);
      }
    }
    if (me.options.enableCursor) {
      me.updateCursor(evt);
    }
  }
  __name(onPointerMove, "onPointerMove");
  function onPointerEnd(evt, tracker) {
    if (me.isPinching && tracker.list.length < 2) {
      if (tracker.list.length === 1) {
        const primary = getPrimary(tracker);
        me.dragStartX = primary.x;
      }
      const endScale = pinch.scale || 1;
      const actualEndZoom = me.timescaleManager.zoom;
      const endTotalZoomDelta = actualEndZoom - pinch.initial.zoom;
      const endZoom = actualEndZoom;
      const endDistance = (pinch.initial.distance || 0) * endScale;
      me.isPinching = false;
      me.trigger(
        "zoom-pinch-end",
        makePinchPayload({
          centre: pinch.centre,
          scale: endScale,
          distance: endDistance,
          zoom: endZoom,
          zoomDelta: 0,
          dx: 0,
          totalZoomDelta: endTotalZoomDelta,
          pointers: [...tracker.list]
        }),
        evt
      );
      return;
    }
    const relativePos = me.getRelativePosition(evt);
    if (clickState.relativePos && isMoveWithinTolerance(clickState.relativePos, relativePos)) {
      if (clickState.isHjsClick) {
        handleHistropediaJSLinkClick();
      } else if (clickState.isTermsClick) {
        handleTermsLinkClick();
      } else if (clickState.isArticleClick) {
        me.select(clickState.article.id);
        clickState.article.clicked(clickState.relativePos);
        if (me.options.enableCursor) {
          me.canvas.style.cursor = clickState.article.getCursor(relativePos);
        }
        me.trigger("article-click", clickState.article, evt);
        if (clickState.isArticleDoubleClick) {
          me.trigger("article-dblclick", clickState.article, evt);
        }
      } else {
        const { left = 0, top = 0 } = clickState.relativePos || {};
        const payload = makeTimelineClickPayload({
          viewport: { x: left, y: top }
        });
        me.trigger("timeline-click", payload, evt);
        if (clickState.isDoubleClick) {
          me.trigger("timeline-dblclick", payload, evt);
        }
      }
    }
    clickState.isDoubleClick = false;
    clickState.isArticleClick = clickState.isArticleDoubleClick = false;
    clickState.isTermsClick = clickState.isHjsClick = false;
    const draggingArticle = me.draggingArticle;
    if (draggingArticle !== null) {
      draggingArticle.stopDragging(evt);
      me.draggingArticle = null;
    } else if (me.isDragging) {
      me.endDragging(evt);
    }
    me.redraw();
  }
  __name(onPointerEnd, "onPointerEnd");
  this._dragPointerTracker = new PointerTracker(this.canvas, {
    onStart: onPointerStart,
    onMove: onPointerMove,
    onEnd: onPointerEnd
  });
}, "enableDragging");
Timeline.prototype.startDragging = /* @__PURE__ */ __name(function startDragging(evt) {
  this.isDragging = true;
  const page = getPoint(evt);
  this.dragOrigin = { left: page.x, top: page.y };
  this.dragStartX = page.x;
  this.dragStartY = page.y;
  this.trigger(
    "viewport-drag-start",
    makeViewportDragPayload({
      startToken: this.timescaleManager.startToken,
      offsetX: this.repositionWindow
    }),
    evt
  );
}, "startDragging");
Timeline.prototype.endDragging = /* @__PURE__ */ __name(function endDragging(evt) {
  this.isDragging = false;
  const page = getPoint(evt);
  const cumulativeMovePixelsX = this.dragOrigin.left - page.x;
  this.trigger(
    "viewport-drag-end",
    makeViewportDragPayload({
      startToken: this.timescaleManager.startToken,
      offsetX: this.repositionWindow,
      totalDx: cumulativeMovePixelsX
    }),
    evt
  );
}, "endDragging");
Timeline.prototype.doDrag = /* @__PURE__ */ __name(function doDrag(evt) {
  if (this.isPanning) {
    this.animation.pan.stop();
  }
  const page = getPoint(evt);
  const movePixelsX = this.dragStartX - page.x;
  const cumulativeMovePixelsX = this.dragOrigin.left - page.x;
  const absMoveFromOriginX = Math.abs(cumulativeMovePixelsX);
  this.dragStartX = page.x;
  if (!this.isAnimating) {
    this.startAnimation();
  }
  if (absMoveFromOriginX > 30) {
    this.animation.dragRedrawFunction = this.defaultRedraw;
  }
  this.updateFromByPixels(movePixelsX);
  this.trigger(
    "viewport-drag",
    makeViewportDragPayload({
      startToken: this.timescaleManager.startToken,
      offsetX: this.repositionWindow,
      dx: movePixelsX,
      totalDx: cumulativeMovePixelsX
    }),
    evt
  );
}, "doDrag");
Timeline.prototype.updateFromByPixels = function(pixels) {
  this.repositionWindow -= pixels;
  let start = this.timescaleManager.startToken;
  let prev = this.timescaleManager.getPrevious(start);
  while (this.repositionWindow >= prev.length) {
    this.repositionWindow -= prev.length;
    start = prev;
    prev = this.timescaleManager.getPrevious(start);
  }
  while (-this.repositionWindow >= start.length) {
    this.repositionWindow += start.length;
    start = this.timescaleManager.getNext(start);
  }
  this.timescaleManager.setStartToken(start);
};
Timeline.prototype.updateMouseoverArticle = function(event, articles = this.articles) {
  const relativePos = this.getRelativePosition(event);
  const oldMouseoverArticle = this.mouseoverArticle;
  let newMouseoverArticle = null;
  for (let i = articles.length - 1; i >= 0; i--) {
    const article = articles[i];
    if (article.isVisible && article.isInside(relativePos)) {
      newMouseoverArticle = article;
      break;
    }
  }
  this.mouseoverArticle = newMouseoverArticle;
  if (oldMouseoverArticle !== newMouseoverArticle) {
    if (oldMouseoverArticle !== null) {
      oldMouseoverArticle.pointerLeave(event);
    }
    if (newMouseoverArticle !== null) {
      newMouseoverArticle.pointerEnter(event);
    }
    this.requestRedraw(this.redraw);
  }
};
Timeline.prototype.load = function(articles) {
  this.addArticles(articles);
  this.updateCurrentDensitySetting();
  this.updateArticlesGroupIndex();
  this.requestRedraw();
};
Timeline.prototype.addArticles = function(articles, progress, callback) {
  if (articles.length == 0) {
    if (callback) {
      callback.call(this);
    }
    return;
  }
  const existingArticleIds = this.articles.map(function(a) {
    return a.id;
  });
  const newArticles = [];
  for (var i = 0; i < articles.length; i++) {
    var article = articles[i];
    if (existingArticleIds.indexOf(getPropertyFromData(article, "id")) === -1) {
      newArticles.push(article);
    }
  }
  for (var i = 0; i < newArticles.length; i++) {
    var article = new Article(this, getPropertyFromData(newArticles[i], "id"));
    this.articles.push(article);
    article.setupByReceivedData(newArticles[i]);
    article.registerPosition(this.getOriginalPosition(article));
  }
  this.updateIsActiveStatus();
  if (callback) {
    callback.call(this);
  }
};
Timeline.prototype.getDmyFromInput = function(dmy) {
  if (!this.options.shiftBceDates) {
    return dmy;
  }
  if (dmy.year < 0) {
    dmy.year += 1;
  }
  return dmy;
};
Timeline.prototype.getActiveArticle = function() {
  for (let i = this.articles.length - 1; i >= 0; i--) {
    if (this.articles[i].isActive) {
      return this.articles[i];
    }
  }
  return null;
};
Timeline.prototype.getArticleById = function(id) {
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.id == id) {
      return article;
    }
  }
};
Timeline.prototype.bringFront = function(articleId) {
  const index = getIndexById(this.articles, articleId);
  if (index >= 0) {
    moveInArray(this.articles, index, this.articles.length - 1);
  }
  this._emitTimelineStateChange();
};
Timeline.prototype.select = function(articleId) {
  this.bringFront(articleId);
  const previousActive = this.getActiveArticle();
  this.updateIsActiveStatus();
  const newActive = this.getActiveArticle();
  if (newActive !== previousActive && newActive) {
    this.trigger("article-select", newActive);
  }
};
Timeline.prototype.activated = function(article) {
  this.select(article.id);
};
Timeline.prototype.updateIsActiveStatus = function() {
  for (var i = 0; i < this.articles.length; i++) {
    this.articles[i].isActive = false;
  }
  for (var i = this.articles.length - 1; i >= 0; i--) {
    if (this.articles[i].isDataLoaded) {
      this.articles[i].isActive = true;
      return;
    }
  }
};
Timeline.prototype.getVisibleArticlesClone = function() {
  const validArticles = [];
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.isVisible && article.isDataLoaded) {
      validArticles.push(article);
    }
  }
  return validArticles;
};
Timeline.prototype.hasArticle = function(articleId) {
  let article;
  for (let i = 0; i < this.articles.length; i++) {
    if (this.articles[i].id === articleId) {
      article = this.articles[i];
    }
  }
  return !isUndefined$1(article);
};
Timeline.prototype.reposition = function(article, drawCycleContext) {
  if (article.isDragging) {
    return;
  }
  const pos = this.getOriginalPosition(article, drawCycleContext);
  article.registeredPosition = pos;
  const finalOffset = article.finalOffset;
  if (!this.options.article.animation.move.active) {
    article.position = {
      left: pos.left + finalOffset.left,
      top: pos.top + finalOffset.top
    };
    article.offset = {
      left: finalOffset.left,
      top: finalOffset.top
    };
    return;
  }
  if (article.moveAnimation.finalOffset.top != finalOffset.top || article.moveAnimation.finalOffset.left != finalOffset.left) {
    article.moveToOffsetWithAnim(
      finalOffset,
      true
      /*with defaultRedraw at end*/
    );
  } else {
    article.position = {
      // but still need to set the position (registered pos is changing on scroll and zoom)
      left: pos.left + article.offset.left,
      top: pos.top + article.offset.top
    };
  }
};
Timeline.prototype.getOriginalPosition = function(article, drawCycleContext) {
  let from = this.getPixel(article.period.from, drawCycleContext);
  if (this.options.article.collectOngoing) {
    const to = this.getPixel(article.period.to, drawCycleContext);
    const isFromNegative = isNaN(from) || from < 0;
    const isToPositive = isNaN(to) || to > 0;
    if (isFromNegative && isToPositive) {
      from = 0;
    }
  }
  const style = article._getCurrentStyle();
  return {
    left: from - style.connectorLine.offsetX,
    top: this.top - this.options.article.distanceToMainLine
  };
};
Timeline.prototype.reorderArticles = function(ids) {
  const result = [];
  for (let i = 0; i < ids.length; i++) {
    const index = getIndexById(this.articles, ids[i]);
    result.push(this.articles[index]);
  }
  const previousActive = this.getActiveArticle();
  this.articles = result;
  this.updateIsActiveStatus();
  const newActive = this.getActiveArticle();
  if (newActive !== previousActive && newActive) {
    this.trigger("article-select", newActive);
  }
  this._emitTimelineStateChange();
};
Timeline.prototype.getSortedByYearClone = function() {
};
Timeline.prototype.removeArticleById = function(id) {
  for (let i = 0; i < this.articles.length; i++) {
    const article = this.articles[i];
    if (article.id == id) {
      if (typeof article._imageCancel === "function") {
        try {
          article._imageCancel();
        } catch (_) {
        }
      }
      if (typeof article._closeImage === "function") {
        try {
          article._closeImage({ skipRedraw: true });
        } catch (_) {
        }
      }
      article._pendingImageKey = null;
      this.articles.splice(i, 1);
      break;
    }
  }
};
Timeline.prototype.deleteCurrentArticle = function() {
  if (this.articles.length == 0) {
    return;
  }
  this.removeById(this.articles, this.getActiveArticle().id);
  this.requestRedraw();
  for (let i = this.articles.length - 1; i >= 0; i--) {
    const article = this.articles[i];
    if (article.isVisible) {
      this.select(article.id);
      this.requestRedraw();
      return;
    }
  }
};
Timeline.prototype.pp = function(msg) {
  let str = "";
  for (let i = 0; i < this.articles.length; i++) {
    str += `${this.articles[i].title.split(" ")[0]},`;
  }
  msg = msg || "";
  Logger.log(`${msg}:${str}`);
};
function getIndexById(arr, id) {
  return arr.findIndex((item) => item.id === id);
}
__name(getIndexById, "getIndexById");
function TimeBand(owner, id) {
  this.id = id;
  this.owner = owner;
  this.isDataLoaded = false;
  this.title = "";
  this.style = {};
  this.period = { from: null, to: null, isToPresent: false };
}
__name(TimeBand, "TimeBand");
TimeBand.prototype.setupByReceivedData = function(receivedData) {
  this.data = { ...receivedData };
  this.title = getPropertyFromData(receivedData, "title") || "";
  this.style = getPropertyFromData(receivedData, "style") || {};
  this._setupPeriod(receivedData);
  this.isDataLoaded = true;
};
TimeBand.prototype._setupPeriod = function(data) {
  const fromDmy = new Dmy(
    parseInt(getPropertyFromData(data, "from.year")),
    parseInt(getPropertyFromData(data, "from.month")),
    parseInt(getPropertyFromData(data, "from.day"))
  );
  this.owner.getDmyFromInput(fromDmy);
  const fromPrecision = parseInt(getPropertyFromData(data, "from.precision"));
  const isToPresentProp = getPropertyFromData(data, "isToPresent");
  const isToPresent = isToPresentProp === true || isToPresentProp === 1;
  let toDmy;
  let toPrecision;
  if (isToPresent) {
    toDmy = Dmy.now();
  } else if (existsInData(data, "to")) {
    toDmy = new Dmy(
      parseInt(getPropertyFromData(data, "to.year")),
      parseInt(getPropertyFromData(data, "to.month")),
      parseInt(getPropertyFromData(data, "to.day"))
    );
    this.owner.getDmyFromInput(toDmy);
    toPrecision = parseInt(getPropertyFromData(data, "to.precision"));
  } else {
    toDmy = fromDmy;
    toPrecision = fromPrecision;
  }
  const from = Dmy.CreateAsStartOfPeriod(fromDmy, fromPrecision);
  const to = Dmy.CreateAsEndOfPeriod(toDmy, toPrecision);
  this.period = { from, to: to.getNextDay(), isToPresent };
};
TimeBand.prototype.overlapsInclusiveWithDates = function(from, to) {
  return !(this.period.from.isAfter(to) || from.isAfter(this.period.to));
};
TimeBand.prototype.setOption = function(option, value) {
  let needsDefaultRedraw = false;
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      return getPropertyFromData(this.data, option);
    }
    option = buildObjectFromPath(option, value);
  }
  deepMerge(this.data, option);
  if (existsInData(option, "id")) {
    this.id = option.id;
  }
  if (existsInData(option, "title")) {
    this.title = option.title;
  }
  if (existsInData(option, "from") || existsInData(option, "to") || existsInData(option, "isToPresent")) {
    this._setupPeriod(this.data);
    needsDefaultRedraw = true;
  }
  if (existsInData(option, "style")) {
    const defaultStyle = this.owner.options.timeBand && this.owner.options.timeBand.defaultStyle || {};
    this.style = deepMerge({}, defaultStyle, this.data.style || {});
  }
  if (needsDefaultRedraw) {
    this.owner.requestRedraw();
  } else {
    this.owner.requestRedraw(this.owner.redraw);
  }
};
TimeBand.prototype.setStyle = function(option, value) {
  if (typeof option === "string") {
    if (typeof value === "undefined") {
      return getPropertyFromData(this.style, option);
    }
    option = buildObjectFromPath(option, value);
  }
  this.data.style = deepMerge(this.data.style || {}, option);
  const defaultStyle = this.owner.options.timeBand && this.owner.options.timeBand.defaultStyle || {};
  this.style = deepMerge({}, defaultStyle, this.data.style || {});
  this.owner.requestRedraw();
};
Object.defineProperty(TimeBand.prototype, "visibility", {
  get() {
    const raw = this && this.data ? this.data.visibility : void 0;
    if (typeof raw === "undefined") {
      return "visible";
    }
    const value = getValueOrFunctionResult(raw, this, this);
    if (value === "visible" || value === "hidden") {
      return value;
    }
    Logger.warn("Invalid TimeBand.visibility value; expected 'visible'|'hidden'. Defaulting to 'visible'", { bandId: this && this.id, value });
    return "visible";
  },
  set(value) {
    if (!this.data) {
      this.data = {};
    }
    this.data.visibility = value;
  },
  enumerable: true,
  configurable: false
});
TimeBand.prototype.draw = function(ctx, geometry) {
  ctx.globalAlpha = 1;
  const left = geometry.left;
  const right = geometry.right;
  const bandTop = geometry.top;
  const bandHeight = geometry.height;
  const width = Math.max(0, right - left);
  if (width <= 0) {
    return;
  }
  const style = this.style || {};
  ctx.fillStyle = style.backgroundColor || "rgba(200,200,200,0.25)";
  ctx.fillRect(left, bandTop, width, bandHeight);
  const border = style.border || null;
  if (border && border.width) {
    ctx.lineWidth = border.width;
    ctx.strokeStyle = border.color || "rgba(120,120,120,0.6)";
    ctx.strokeRect(left + 0.5, bandTop + 0.5, width - 1, bandHeight - 1);
  }
  const textStyle = style.text || {};
  const margin = textStyle.margin || 6;
  const maxTextWidth = Math.max(0, width - margin * 2);
  if (maxTextWidth > 2) {
    ctx.font = textStyle.font || "500 12px Calibri";
    ctx.textAlign = textStyle.align || "center";
    ctx.textBaseline = textStyle.baseline || "middle";
    ctx.fillStyle = textStyle.color || "#222";
    const text = this.title || "";
    const measured = ctx.measureText(text).width;
    let label = text;
    if (measured > maxTextWidth) {
      const originalMeasure = ctx.measureText.bind(ctx);
      let leftIdx = 0, rightIdx = text.length, best = 0;
      const suffix = "…";
      const suffixWidth = originalMeasure(suffix).width;
      const available = Math.max(0, maxTextWidth - suffixWidth);
      while (leftIdx <= rightIdx) {
        const mid = Math.floor((leftIdx + rightIdx) / 2);
        const slice = text.substring(0, mid);
        const widthMid = originalMeasure(slice).width;
        if (widthMid <= available) {
          best = mid;
          leftIdx = mid + 1;
        } else {
          rightIdx = mid - 1;
        }
      }
      label = best > 0 ? `${text.substring(0, best)}…` : "";
    }
    const textX = textStyle.align === "left" ? left + margin : textStyle.align === "right" ? right - margin : Math.floor((left + right) / 2);
    let textY;
    const vAlign = textStyle.verticalAlign || "middle";
    switch (vAlign) {
      case "top":
        textY = bandTop + (textStyle.margin || 0);
        break;
      case "bottom":
        textY = bandTop + bandHeight - (textStyle.margin || 0);
        break;
      case "middle":
      default:
        textY = bandTop + Math.floor(bandHeight / 2);
        break;
    }
    textY += textStyle.offsetY || 0;
    ctx.fillText(label, textX, textY);
  }
};
function noShadow(context) {
  context.shadowBlur = 0;
  context.shadowOffsetX = 0;
  context.shadowOffsetY = 0;
  context.shadowColor = "transparent black";
}
__name(noShadow, "noShadow");
function topRoundRectPath(ctx, x, y, width, height, radius) {
  ctx.moveTo(x + radius, y);
  ctx.lineTo(x + width - radius, y);
  if (radius > 0) {
    ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
  }
  ctx.lineTo(x + width, y + height);
  ctx.lineTo(x, y + height);
  ctx.lineTo(x, y + radius);
  if (radius > 0) {
    ctx.quadraticCurveTo(x, y, x + radius, y);
  }
  if (radius == 0) {
    ctx.closePath();
  }
}
__name(topRoundRectPath, "topRoundRectPath");
function drawRoundedRect(ctx, x, y, width, height, radius) {
  ctx.beginPath();
  ctx.moveTo(x + radius, y);
  ctx.lineTo(x + width - radius, y);
  ctx.arcTo(x + width, y, x + width, y + radius, radius);
  ctx.lineTo(x + width, y + height - radius);
  ctx.arcTo(x + width, y + height, x + width - radius, y + height, radius);
  ctx.lineTo(x + radius, y + height);
  ctx.arcTo(x, y + height, x, y + height - radius, radius);
  ctx.lineTo(x, y + radius);
  ctx.arcTo(x, y, x + radius, y, radius);
  ctx.closePath();
}
__name(drawRoundedRect, "drawRoundedRect");
function drawStar(ctx, cx, cy, spikes, r0, r1, fillColour, strokeColour) {
  ctx.beginPath();
  const angle = Math.PI / spikes;
  for (let i = 0; i < 2 * spikes; i++) {
    const r = (i & 1) == 0 ? r1 : r0;
    const currX = cx + Math.cos(1 + i * angle) * r;
    const currY = cy + Math.sin(1 + i * angle) * r;
    if (i == 0) {
      ctx.moveTo(currX, currY);
    } else {
      ctx.lineTo(currX, currY);
    }
  }
  ctx.closePath();
  ctx.lineWidth = 1;
  ctx.strokeStyle = strokeColour;
  ctx.fillStyle = fillColour;
  ctx.stroke();
  ctx.fill();
}
__name(drawStar, "drawStar");
function getTextOrigin(left, width, textAlign, margin, snap) {
  let textOriginX;
  switch (textAlign) {
    case "left":
      textOriginX = left + margin;
      break;
    case "center":
      textOriginX = left + width / 2;
      break;
    case "right":
      textOriginX = left + width - margin;
      break;
    default:
      textOriginX = left + margin;
  }
  if (typeof snap === "function") {
    return snap(textOriginX);
  }
  if (textAlign === "center") {
    return left + Math.floor(width / 2);
  }
  return textOriginX;
}
__name(getTextOrigin, "getTextOrigin");
function drawCircleImage(ctx, image, sx, sy, sWidth, sHeight, dx, dy, diameter) {
  const radius = diameter / 2;
  ctx.save();
  ctx.beginPath();
  ctx.arc(dx + radius, dy + radius, radius, 0, Math.PI * 2, false);
  ctx.closePath();
  ctx.clip();
  ctx.drawImage(image, sx, sy, sWidth, sHeight, dx, dy, diameter, diameter);
  ctx.restore();
}
__name(drawCircleImage, "drawCircleImage");
function getTextLines(text, ctx, maxWidth) {
  const words = text.split(" ");
  const lines = [];
  let currentLine = words[0];
  for (let i = 1; i < words.length; i++) {
    const word = words[i];
    const width = ctx.measureText(`${currentLine} ${word}`).width;
    if (width < maxWidth) {
      currentLine += ` ${word}`;
    } else {
      lines.push(currentLine);
      currentLine = word;
    }
  }
  lines.push(currentLine);
  return lines;
}
__name(getTextLines, "getTextLines");
function ellipsizeText(ctx, text, maxWidth, suffix = "…") {
  if (!ctx || typeof ctx.measureText !== "function") {
    throw new Error("Invalid canvas context provided");
  }
  if (typeof text !== "string") {
    return "";
  }
  if (text === "") {
    return "";
  }
  if (typeof maxWidth !== "number" || maxWidth <= 0) {
    return "";
  }
  if (typeof suffix !== "string") {
    suffix = "…";
  }
  const originalWidth = ctx.measureText(text).width;
  if (originalWidth <= maxWidth) {
    return text;
  }
  const suffixWidth = ctx.measureText(suffix).width;
  if (suffixWidth >= maxWidth) {
    return "";
  }
  const availableTextWidth = maxWidth - suffixWidth;
  if (availableTextWidth <= 0) {
    return "";
  }
  let left = 0;
  let right = text.length;
  let bestFit = 0;
  while (left <= right) {
    const mid = Math.floor((left + right) / 2);
    const prefix = text.substring(0, mid);
    const prefixWidth = ctx.measureText(prefix).width;
    if (prefixWidth <= availableTextWidth) {
      bestFit = mid;
      left = mid + 1;
    } else {
      right = mid - 1;
    }
  }
  if (bestFit === 0) {
    return "";
  }
  return text.substring(0, bestFit) + suffix;
}
__name(ellipsizeText, "ellipsizeText");
function truncateTextLines(textLines, maxLines, ctx = null, maxWidth = null) {
  if (!Array.isArray(textLines) || textLines.length === 0) {
    return textLines;
  }
  if (typeof maxLines !== "number" || maxLines <= 0) {
    return [];
  }
  const needsLineTruncation = textLines.length > maxLines;
  const workingLines = needsLineTruncation ? textLines.slice(0, maxLines) : [...textLines];
  if (workingLines.length > 0) {
    const finalLineIndex = workingLines.length - 1;
    const finalLine = workingLines[finalLineIndex];
    if (ctx && typeof maxWidth === "number" && maxWidth > 0) {
      if (needsLineTruncation) {
        const ellipsizedLine = ellipsizeText(ctx, finalLine, maxWidth);
        workingLines[finalLineIndex] = ellipsizedLine;
        if (ellipsizedLine === finalLine) {
          workingLines[finalLineIndex] = ellipsizeText(ctx, `${finalLine}…`, maxWidth, "…");
        }
      } else {
        workingLines[finalLineIndex] = ellipsizeText(ctx, finalLine, maxWidth);
      }
    } else if (needsLineTruncation) {
      workingLines[finalLineIndex] += "...";
    }
  }
  return workingLines;
}
__name(truncateTextLines, "truncateTextLines");
const DEFAULT_AREA_FALLBACK = { up: 0, down: 0 };
function resolveAreaExtents(areaConfig, options = {}) {
  const { anchorY = 0, canvasHeight = 0, fallbackArea = DEFAULT_AREA_FALLBACK } = options;
  const safeAnchor = Number.isFinite(anchorY) ? anchorY : 0;
  const safeCanvasHeight = Number.isFinite(canvasHeight) ? canvasHeight : 0;
  const fallbackUp = typeof fallbackArea?.up === "number" && Number.isFinite(fallbackArea.up) ? Math.max(0, fallbackArea.up) : 0;
  const fallbackDown = typeof fallbackArea?.down === "number" && Number.isFinite(fallbackArea.down) ? Math.max(0, fallbackArea.down) : 0;
  const area = areaConfig || fallbackArea || DEFAULT_AREA_FALLBACK;
  const hasCustomArea = !!areaConfig;
  const rawUpValue = typeof area.up === "undefined" ? hasCustomArea ? 0 : fallbackUp : area.up;
  const rawDownValue = typeof area.down === "undefined" ? hasCustomArea ? 0 : fallbackDown : area.down;
  const resolveValue = /* @__PURE__ */ __name((direction, value) => {
    if (typeof value === "number") {
      return Number.isFinite(value) ? Math.max(0, value) : 0;
    }
    const isEdgeObject = typeof value === "object" && value !== null && value.value === "edge";
    if (value === "edge" || isEdgeObject) {
      const rawPadding = isEdgeObject ? value.padding : 0;
      const padding = typeof rawPadding === "number" && Number.isFinite(rawPadding) ? Math.max(0, rawPadding) : 0;
      const limit = direction === "up" ? Math.max(0, safeAnchor) : Math.max(0, safeCanvasHeight - safeAnchor);
      return Math.max(0, limit - padding);
    }
    return 0;
  }, "resolveValue");
  const up = resolveValue("up", rawUpValue);
  const down = resolveValue("down", rawDownValue);
  return {
    up,
    down,
    height: up + down
  };
}
__name(resolveAreaExtents, "resolveAreaExtents");
Timeline.prototype.defaultRedraw = function() {
  this.redraw({
    // 1. update isVisibleInGroup and after articles IsInRange is decided
    onArticlesInRangeIsReady: /* @__PURE__ */ __name(function defaultRedraw_onArticlesInRangeIsReady(drawCycleContext) {
      this.updateVisibleArticlesOfGroups(drawCycleContext);
      this.forInRangeArticles(/* @__PURE__ */ __name(function defaultRedraw_repositionArticles(article) {
        this.reposition(article, drawCycleContext);
      }, "defaultRedraw_repositionArticles"));
      this.stack(drawCycleContext);
    }, "defaultRedraw_onArticlesInRangeIsReady"),
    // 2. make sure articles move with the dragged line by repositioning them
    onArticlesVisiblityIsReady: /* @__PURE__ */ __name(function defaultRedraw_onArticlesVisiblityIsReady(drawCycleContext) {
      this.updateArticleLines();
    }, "defaultRedraw_onArticlesVisiblityIsReady")
  });
};
Timeline.prototype.repositionRedraw = function() {
  this.redraw({
    // 1. update isVisibleInGroup and after articles IsInRange is decided
    onArticlesInRangeIsReady: /* @__PURE__ */ __name(function defaultRedraw_onArticlesInRangeIsReady(drawCycleContext) {
      this.updateVisibleArticlesOfGroups(drawCycleContext);
      this.forInRangeArticles(/* @__PURE__ */ __name(function defaultRedraw_repositionArticles(article) {
        this.reposition(article, drawCycleContext);
      }, "defaultRedraw_repositionArticles"));
    }, "defaultRedraw_onArticlesInRangeIsReady"),
    // 2. make sure articles move with the dragged line by repositioning them
    onArticlesVisiblityIsReady: /* @__PURE__ */ __name(function defaultRedraw_onArticlesVisiblityIsReady(drawCycleContext) {
      this.updateArticleLines();
    }, "defaultRedraw_onArticlesVisiblityIsReady")
  });
};
Timeline.prototype.redraw = function(callbacks) {
  if (this.redrawInProgress) {
    return;
  }
  this.redrawInProgress = true;
  const initialTopRow = this.topRow;
  callbacks = callbacks || {};
  const ctx = this.canvasContext;
  const width = this.getWidth();
  const top = this.top;
  this.trigger("timeline-render-start", {
    canvasContext: ctx,
    top
  });
  const drawCycleContext = {};
  const mainline = this.getTokensAndMarkers(width), markers = mainline.markers, tokens = mainline.tokens;
  drawCycleContext.tokens = tokens;
  this.invoke("onMainRangeIsReady", callbacks, drawCycleContext);
  this.forLoadedArticles(/* @__PURE__ */ __name(function redraw_articles_updateIsInRange(article) {
    article.isInView = article.overlapsInclusiveWithDates(
      drawCycleContext.tokens.start,
      drawCycleContext.tokens.end
    );
    if (this.options.article.autoStacking.range == RANGE_SCREEN) {
      article.isInRange = article.isInView;
    } else {
      article.isInRange = true;
    }
    if (article.isInRange) {
      article.isHiddenByFilter = article.hiddenByFilter;
    }
  }, "redraw_articles_updateIsInRange"));
  this.invoke("onArticlesInRangeIsReady", callbacks, drawCycleContext);
  this.forLoadedArticles(/* @__PURE__ */ __name(function redraw_articles_updateVisibility(article) {
    article.updateVisibility();
  }, "redraw_articles_updateVisibility"));
  this.forVisibleArticles(/* @__PURE__ */ __name(function ensure_images_enqueued(article) {
    this.enqueueImageLoad(article);
  }, "ensure_images_enqueued"));
  this.invoke("onArticlesVisiblityIsReady", callbacks, drawCycleContext);
  this.forInRangeArticles(/* @__PURE__ */ __name(function redraw_articles_setIndicators(article) {
    article.indicator = {
      // performance: canvas works better with int, hence the Math.round
      fromX: Math.max(-3, Math.round(this.getPixel(article.period.from, drawCycleContext))),
      //-3 instead of 0 minimum ensures indicators don't 'pin' to left edge
      toX: Math.min(
        this.options.width,
        Math.round(this.getPixel(article.period.to, drawCycleContext))
      )
    };
    if (article.indicator.toX - article.indicator.fromX < 2) {
      article.indicator.toX = article.indicator.fromX + 2;
    }
  }, "redraw_articles_setIndicators"));
  if (this.options.article.autoStacking.fitToHeight && initialTopRow !== this.topRow) {
    this.fitToHeight(
      true
      /*withDefaultRedraw*/
    );
  }
  this.render(ctx, top, width, markers);
  this.redrawInProgress = false;
  this.trigger("timeline-render-end", {
    canvasContext: ctx,
    drawCycleContext,
    top
  });
};
Timeline.prototype.render = function(ctx, top, width, markers) {
  const halfMainlineSize = this.options.style.mainLine.size >> 1;
  const effectiveVerticalOffset = this._getEffectiveVerticalOffset ? this._getEffectiveVerticalOffset() : this.options.verticalOffset;
  if (!this.owner) {
    ctx.clearRect(0, 0, width, this.top + effectiveVerticalOffset);
  }
  this.drawTimeBands(ctx, top, width);
  this.drawDraggingHighlight(ctx, top, width);
  const mainLineTop = this.options.style.mainLine.position === "top" ? -effectiveVerticalOffset : top;
  this.drawMainline(ctx, mainLineTop, width, markers);
  if (this.options.style.mainLine.showDateIndicators) {
    ctx.beginPath();
    this.forInRangeArticles(/* @__PURE__ */ __name(function redraw_articles_drawIndicators(article2) {
      if (!article2.isHiddenByFilter && article2.isInView) {
        ctx.moveTo(article2.indicator.fromX, top - halfMainlineSize);
        ctx.lineTo(article2.indicator.fromX, top + halfMainlineSize);
      }
    }, "redraw_articles_drawIndicators"));
    ctx.lineWidth = 3;
    ctx.globalAlpha = 0.75;
    ctx.strokeStyle = "#303030";
    ctx.stroke();
  }
  ctx.globalAlpha = 1;
  for (let i = 0; i < this.articles.length; i++) {
    var article = this.articles[i];
    if (article.isDataLoaded && article.isVisible && !article.isActive) {
      article.drawPeriodLinesAndConnectors(ctx, top);
    }
  }
  for (let i = 0; i < this.articles.length; i++) {
    var article = this.articles[i];
    if (article.isDataLoaded && article.isVisible && !article.isActive) {
      article.draw(ctx);
    }
  }
  const activeArticle = this.getActiveArticle();
  if (activeArticle && activeArticle.isVisible) {
    activeArticle.drawPeriodLinesAndConnectors(ctx, top);
    activeArticle.draw(ctx);
  }
  if (!this.options.disableBranding) {
    ctx.globalAlpha = 1;
    this._drawBranding(ctx);
  }
};
Timeline.prototype.drawMainline = function(ctx, top, width, markers) {
  if (this.options.style.mainLine.visible) {
    ctx.globalAlpha = 1;
    const halfMainlineSize = this.options.style.mainLine.size >> 1;
    const mainLineGradient = ctx.createLinearGradient(
      0,
      top - halfMainlineSize,
      0,
      top + halfMainlineSize
    );
    mainLineGradient.addColorStop(0, "#808080");
    mainLineGradient.addColorStop(1, "#ccc");
    ctx.beginPath();
    ctx.lineWidth = this.options.style.mainLine.size;
    ctx.strokeStyle = ctx.fillStyle = mainLineGradient;
    ctx.moveTo(0, top);
    ctx.lineTo(width, top);
    ctx.stroke();
    for (const type in markers) {
      this.drawMarkersAndLabels(ctx, markers[type], type, top + halfMainlineSize);
    }
  }
};
Timeline.prototype.drawDraggingHighlight = function(ctx, top, width) {
  if (!this.isDragging) {
    return;
  }
  const highlightOptions = this.options.style.draggingHighlight || {};
  if (!highlightOptions.visible) {
    return;
  }
  ctx.fillStyle = highlightOptions.color;
  const anchorTop = this.top;
  const canvasHeight = this.options.height;
  const fallbackArea = { up: 0, down: 60 };
  const { up, height } = resolveAreaExtents(highlightOptions.area, {
    anchorY: anchorTop,
    canvasHeight,
    fallbackArea
  });
  if (height <= 0) {
    return;
  }
  ctx.fillRect(0, anchorTop - up, width, height);
};
Timeline.prototype.drawTimeBands = function(ctx, top, width) {
  const cfg = this.options.timeBand || {};
  if (!cfg.visible) {
    return;
  }
  if (!this.timeBands || this.timeBands.length === 0) {
    return;
  }
  const drawCycleContext = { tokens: this.getTokensAndMarkers(width).tokens };
  const bands = this._getVisibleTimeBands(drawCycleContext);
  if (bands.length === 0) {
    return;
  }
  const anchorTop = this.top;
  const canvasHeight = this.options.height;
  const fallbackArea = { up: 0, down: 40 };
  const { up: resolvedUp, height: bandHeight } = resolveAreaExtents(cfg.area, {
    anchorY: anchorTop,
    canvasHeight,
    fallbackArea
  });
  if (bandHeight <= 0) {
    return;
  }
  const bandTop = anchorTop - resolvedUp;
  ctx.save();
  for (let i = 0; i < bands.length; i++) {
    const band = bands[i];
    let left = Math.round(this.getPixel(band.period.from, drawCycleContext));
    let right = Math.round(this.getPixel(band.period.to, drawCycleContext));
    if (right < 0 || left > width) {
      continue;
    }
    left = Math.max(0, left);
    right = Math.min(width, right);
    if (right - left <= 0) {
      continue;
    }
    band.draw(ctx, { left, right, top: bandTop, height: bandHeight });
  }
  ctx.restore();
};
Timeline.prototype.getTokensAndMarkers = function(width) {
  const tokens = {};
  const markers = {};
  markers[MAJOR_MARKER] = [];
  markers[MINOR_MARKER] = [];
  let x = this.repositionWindow;
  var token = this.timescaleManager.startToken;
  tokens.start = token.value;
  let endToken = token;
  const leftBufferNumberOfTokens = 9;
  var token = this.timescaleManager.getPreviousNth(token, leftBufferNumberOfTokens);
  x -= token.length * leftBufferNumberOfTokens;
  do {
    markers[token.type].push(token);
    tokens[token.value.toKeyString()] = token.drawX = x;
    x += token.length;
    endToken = token;
    token = this.timescaleManager.getNext(token);
  } while (x < width + 150);
  tokens.end = endToken.value;
  return { tokens, markers };
};
Timeline.prototype.drawMarkersAndLabels = function(ctx, tokens, tokenType, markerTop) {
  if (tokens.length === 0) {
    return;
  }
  switch (tokenType) {
    case JSON.stringify(MINOR_MARKER):
      tokenType = "minor";
      break;
    case JSON.stringify(MAJOR_MARKER):
      tokenType = "major";
      break;
    default:
      Logger.log("token type not recognised", tokenType, MINOR_MARKER);
  }
  const markerStyle = this.options.style.marker[tokenType];
  const isExtended = markerStyle.extend;
  const markerDirection = this.options.style.mainLine.position === "top" ? -1 : 1;
  const markerHeight = markerStyle.height;
  const withLabel = !!tokens[0].label;
  let isInFuture = tokens[0].value.isInFuture();
  let wasInPast = !isInFuture;
  if (markerDirection === -1) {
    markerTop -= this.options.style.mainLine.size;
  }
  if (withLabel) {
    var labelStyle = this.options.style.dateLabel[tokenType];
    ctx.font = labelStyle.font;
    ctx.textAlign = labelStyle.textAlign;
    ctx.textBaseline = markerDirection === 1 ? "alphabetic" : "top";
    var labelY = markerTop + markerHeight * markerDirection + labelStyle.offset.y;
  }
  ctx.beginPath();
  for (let i = 0; i < tokens.length; i++) {
    const token = tokens[i];
    isInFuture = token.value.isInFuture();
    if (wasInPast && isInFuture) {
      wasInPast = false;
      ctx.strokeStyle = markerStyle.color;
      ctx.lineWidth = 1;
      ctx.stroke();
      ctx.beginPath();
    }
    const drawX = Math.round(token.drawX);
    ctx.moveTo(drawX, markerTop + markerHeight * markerDirection);
    const markerEndY = isExtended ? markerTop + -1 * markerDirection * this.top : markerTop;
    ctx.lineTo(drawX, markerEndY);
    if (withLabel && token.label) {
      const labelX = drawX + labelStyle.offset.x;
      ctx.fillStyle = isInFuture ? labelStyle.futureColor : labelStyle.color;
      ctx.fillText(token.label, labelX, labelY);
    }
  }
  ctx.strokeStyle = isInFuture ? markerStyle.futureColor : markerStyle.color;
  ctx.lineWidth = 1;
  ctx.stroke();
};
Timeline.prototype.loadTimeBands = function(timeBands) {
  this.addTimeBands(timeBands);
  if (typeof this._getEffectiveVerticalOffset === "function") {
    this.top = this.options.height - this._getEffectiveVerticalOffset();
  }
  this.requestRedraw();
};
Timeline.prototype.addTimeBands = function(timeBands) {
  if (!Array.isArray(timeBands) || timeBands.length === 0) {
    return;
  }
  const existingIds = this.timeBands.map((e) => e.id);
  const newData = timeBands.filter((e) => existingIds.indexOf(e.id) === -1);
  const defaultStyle = this.options.timeBand && this.options.timeBand.defaultStyle || {};
  for (let i = 0; i < newData.length; i++) {
    const data = newData[i];
    const band = new TimeBand(this, data.id);
    band.setupByReceivedData(data);
    band.style = deepMerge({}, defaultStyle, data.style || {});
    this.timeBands.push(band);
  }
  if (typeof this._getEffectiveVerticalOffset === "function") {
    this.top = this.options.height - this._getEffectiveVerticalOffset();
  }
};
Timeline.prototype._getVisibleTimeBands = function(drawCycleContext) {
  if (!this.timeBands || this.timeBands.length === 0) {
    return [];
  }
  const start = drawCycleContext.tokens.start;
  const end = drawCycleContext.tokens.end;
  return this.timeBands.filter(
    (b) => b.isDataLoaded && b.visibility !== "hidden" && b.overlapsInclusiveWithDates(start, end)
  );
};
Timeline.prototype.updateArticleLines = function() {
  const me = this;
  function prepare(articles2) {
    const result = [];
    me.forVisibleArticles(function(article) {
      if (!article.hidePeriodLine) {
        result.push(article);
        result[result.length - 1].stacking = -1;
      }
    });
    result.sort(me.options.article.periodLine.stacking.sorter);
    if (me.options.article.periodLine.stacking.reverseOrder) {
      result.reverse();
    }
    return result;
  }
  __name(prepare, "prepare");
  function canPutOnStack(article, articlesOnStack) {
    for (let i = 0; i < articlesOnStack.length; i++) {
      if (article.overlaps(articlesOnStack[i])) {
        return false;
      }
    }
    return true;
  }
  __name(canPutOnStack, "canPutOnStack");
  const articles = prepare(this.articles);
  let currentStack = 0;
  const stacks = [];
  do {
    stacks[currentStack] = [];
    var articleAddedToStack = false;
    for (let i = 0; i < articles.length; i++) {
      const article = articles[i];
      if (article.stacking >= 0) {
        continue;
      }
      if (canPutOnStack(article, stacks[currentStack])) {
        stacks[currentStack].push(article);
        article.stacking = currentStack;
        articleAddedToStack = true;
      }
    }
    currentStack++;
  } while (articleAddedToStack);
};
Timeline.prototype.stack = function(drawCycleContext) {
  if (this.articles.length == 0) {
    return;
  }
  const rowHeight = this.options.article.autoStacking.rowSpacing;
  if (!this.options.article.autoStacking.active) {
    return;
  }
  function prepare(articles2) {
    let selected;
    const starred = [];
    const rest = [];
    for (let i2 = 0; i2 < articles2.length; i2++) {
      const article = articles2[i2];
      if (article.isDataLoaded && article.isInRange && article.isVisibleInGroup && !article.isHiddenByFilter) {
        if (article.isActive) {
          selected = article;
        } else if (article.isStarred) {
          starred.push(article);
        } else {
          rest.push(article);
        }
      }
    }
    starred.sort(ARTICLE_RANK_SORTER);
    rest.sort(ARTICLE_RANK_SORTER);
    return [].concat(
      selected ? selected : [],
      // in case nothing is selected
      starred,
      rest
    );
  }
  __name(prepare, "prepare");
  function overlapsWithNoArticleInRow(row, article) {
    for (let i2 = 0; i2 < row.length; i2++) {
      const articleInRow = row[i2];
      if (article.headerOverlapsWith(articleInRow)) {
        return false;
      }
    }
    return true;
  }
  __name(overlapsWithNoArticleInRow, "overlapsWithNoArticleInRow");
  function findFirstAvailableRow(rows2, article) {
    for (let i2 = 0; i2 < rows2.length; i2++) {
      if (overlapsWithNoArticleInRow(rows2[i2], article)) {
        return i2;
      }
    }
    return rows2.length;
  }
  __name(findFirstAvailableRow, "findFirstAvailableRow");
  function tryPutInRowsHorizontal(rows2, article) {
    const firstAvailableRow = findFirstAvailableRow(rows2, article);
    if (firstAvailableRow >= rows2.length) {
      rows2[firstAvailableRow] = [];
    }
    rows2[firstAvailableRow].push(article);
    return true;
  }
  __name(tryPutInRowsHorizontal, "tryPutInRowsHorizontal");
  const articles = prepare(this.articles), rows = [];
  for (var i = 0; i < articles.length; i++) {
    articles[i].isVisibleInRows = tryPutInRowsHorizontal(rows, articles[i]);
  }
  this.topRow = 0;
  for (let r = 0; r < rows.length; r++) {
    for (var i = 0; i < rows[r].length; i++) {
      const article = rows[r][i];
      article.finalOffset = {
        left: 0,
        // keep lines straight and vertical
        top: r * -rowHeight
      };
      article.row = r;
      if (article.isInView) {
        this.topRow = Math.max(this.topRow, r);
      }
      this.reposition(article, drawCycleContext);
    }
  }
  const currentActiveArticle = this.getActiveArticle();
  this.articles.sort(ARTICLE_ROW_SORTER);
  if (currentActiveArticle) {
    this.bringFront(currentActiveArticle.id);
  }
};
Timeline.prototype.notifyEventSpacingChanged = function() {
  this.requestRedraw(this.defaultRedraw);
};
function normalizeWheelDelta(evt, mode = "discrete") {
  let raw = 0;
  if ("deltaY" in evt && typeof evt.deltaY === "number" && evt.deltaY !== 0) {
    raw = -evt.deltaY;
  } else if ("wheelDelta" in evt && typeof evt.wheelDelta === "number" && evt.wheelDelta !== 0) {
    raw = evt.wheelDelta;
  } else if ("detail" in evt && typeof evt.detail === "number" && evt.detail !== 0) {
    raw = -evt.detail;
  }
  if (mode === "discrete") {
    return raw > 0 ? 1 : -1;
  }
  const scaled = raw / 120;
  return scaled === 0 ? 0 : scaled;
}
__name(normalizeWheelDelta, "normalizeWheelDelta");
Timeline.prototype.enableZoomByWheel = /* @__PURE__ */ __name(function enableZoomByWheel() {
  if (this._wheelEnabled) {
    return;
  }
  this._wheelEnabled = true;
  this._wheelHandler = (evt) => {
    const { allowCtrlWheel = false, wheelMode = "auto" } = this.options.zoom || {};
    if (!allowCtrlWheel && evt.ctrlKey) {
      return;
    }
    const normalizeMode = wheelMode === "discrete" ? "discrete" : "proportional";
    const delta = normalizeWheelDelta(evt, normalizeMode);
    this.onWheel(evt, delta);
  };
  this.canvas.addEventListener("wheel", this._wheelHandler, { passive: false });
  this.canvas.addEventListener("DOMMouseScroll", this._wheelHandler, { passive: false });
}, "enableZoomByWheel");
Timeline.prototype.disableZoomByWheel = /* @__PURE__ */ __name(function disableZoomByWheel() {
  if (!this._wheelEnabled) {
    return;
  }
  this.canvas.removeEventListener("wheel", this._wheelHandler);
  this.canvas.removeEventListener("DOMMouseScroll", this._wheelHandler);
  this._wheelEnabled = false;
  this._wheelHandler = null;
}, "disableZoomByWheel");
Timeline.prototype.onWheel = /* @__PURE__ */ __name(function onWheel(event, delta) {
  const { wheelSpeed, wheelStep, maximum, minimum, proportionalGain, proportionalExponent, wheelMode } = this.options.zoom;
  const useProportional = wheelMode !== "discrete";
  function isDiscreteWheel(evt) {
    if (evt.deltaMode === 1) {
      return true;
    }
    if (typeof evt.deltaY === "number") {
      const dy = Math.abs(evt.deltaY);
      if (dy >= 100) {
        if (dy % 120 === 0) {
          return true;
        }
      }
    }
    if ("wheelDelta" in evt && typeof evt.wheelDelta === "number") {
      const wd = Math.abs(evt.wheelDelta);
      if (wd % 120 === 0) {
        return true;
      }
    }
    return false;
  }
  __name(isDiscreteWheel, "isDiscreteWheel");
  if (useProportional && !isDiscreteWheel(event)) {
    const sign = Math.sign(delta) || 1;
    let mag = Math.abs(delta);
    if (mag >= 1 && proportionalExponent && proportionalExponent !== 1) {
      mag = Math.pow(mag, proportionalExponent);
    }
    mag *= proportionalGain;
    delta = sign * mag;
  } else if (useProportional && isDiscreteWheel(event)) {
    delta = delta > 0 ? 1 : -1;
  }
  let newZoom = this.timescaleManager.zoom + -delta * wheelSpeed * wheelStep;
  if (newZoom > maximum) {
    newZoom = maximum;
  }
  if (newZoom < minimum) {
    newZoom = minimum;
  }
  let mousePositionX;
  let mousePositionY;
  if (event.target === this.canvas && "offsetX" in event && typeof event.offsetX === "number") {
    mousePositionX = event.offsetX;
    mousePositionY = event.offsetY;
  } else {
    const rect = this.canvas.getBoundingClientRect();
    mousePositionX = event.clientX - rect.left;
    mousePositionY = event.clientY - rect.top;
  }
  const previousZoom = this.timescaleManager.zoom;
  this.setZoomByPivotPixel(newZoom, mousePositionX);
  const actualNewZoom = this.timescaleManager.zoom;
  const zoomDelta = actualNewZoom - previousZoom;
  this.requestRedraw();
  event.preventDefault();
  this.trigger(
    "zoom-wheel",
    makeWheelPayload({
      centre: { x: mousePositionX, y: mousePositionY },
      zoom: actualNewZoom,
      zoomDelta
    }),
    event
  );
}, "onWheel");
Timeline.prototype.setZoom = /* @__PURE__ */ __name(function setZoom(newZoom, pivotPixel, offsetX = 0) {
  const pivot = pivotPixel == null ? this.width / 2 : pivotPixel;
  const dx = offsetX ? Math.round(offsetX) : 0;
  this.setZoomByPivotPixel(newZoom, pivot, dx);
  this.requestRedraw();
}, "setZoom");
Timeline.prototype.setZoomByPivotPixel = /* @__PURE__ */ __name(function setZoomByPivotPixel(newZoom, pivotPixel, offsetX = 0) {
  this.setZoomByPivotPoint(newZoom, this.getPivotPoint(pivotPixel), pivotPixel, offsetX);
}, "setZoomByPivotPixel");
Timeline.prototype.setZoomByPivotPoint = /* @__PURE__ */ __name(function setZoomByPivotPoint(newZoom, pivotPoint, pivotPixel, offsetX = 0) {
  this.timescaleManager.setZoom(newZoom);
  const compensation = this.timescaleManager.setStartDate(pivotPoint.date);
  this.repositionWindow = compensation - pivotPoint.fraction;
  this.updateFromByPixels(-pivotPixel + offsetX);
}, "setZoomByPivotPoint");
Timeline.prototype.getPivotPoint = /* @__PURE__ */ __name(function getPivotPoint(pixel) {
  let token = this.timescaleManager.getStartTokenCloned();
  let x = this.repositionWindow;
  if (x >= 0) {
    token = this.timescaleManager.getPrevious(token);
    x -= token.length;
  }
  let prevToken = token;
  while (x <= pixel) {
    x += token.length;
    prevToken = token;
    token = this.timescaleManager.getNext(token);
  }
  const unit = prevToken.unit;
  const len = prevToken.length;
  let fraction = pixel - (x - token.length);
  const dmy = prevToken.value;
  let { year, month, day } = dmy;
  if (unit === ZOOM_MONTH) {
    day = Math.floor(fraction / len * 30.44) + 1;
    fraction -= (day - 1) * len / 30.44;
    prevToken.value = new Dmy(year, month, day);
  } else if (unit !== ZOOM_DAY) {
    const yearMultiple = this.timescaleManager.unitLengthInYears;
    let daysFromToken = Math.floor(fraction * 365.2422 * yearMultiple / len) + 1;
    let extraYears = 0;
    if (daysFromToken > 365) {
      extraYears = Math.floor(daysFromToken / 365);
      daysFromToken = daysFromToken - 365 * extraYears;
    }
    fraction = 0;
    prevToken.value = Dmy.getByDayOfYear(year + extraYears, daysFromToken);
  }
  return {
    date: prevToken.value,
    fraction
  };
}, "getPivotPoint");
Timeline.prototype.startAnimation = function(redrawFunction) {
  if (this.isAnimating) {
    return;
  }
  this.isAnimating = true;
  this.animation.redrawFunction = redrawFunction;
  this.drawAnimationFrame();
};
Timeline.prototype.stopAnimation = function() {
  this.isAnimating = false;
  this.animation.dragRedrawFunction = this.repositionRedraw;
  this.animation.redrawFunction = false;
};
Timeline.prototype.areAnimationsFinished = function() {
  return !(this.isDragging || this.isPanning || this.isPinching || this.draggingArticle !== null || this.isAnimatingArticles || this.isCustomAnimating);
};
Timeline.prototype.drawAnimationFrame = function() {
  if (this.areAnimationsFinished()) {
    return this.stopAnimation();
  }
  const me = this;
  const redrawFunction = this.getAnimationRedrawFunction();
  this.updateRedrawRequests(redrawFunction);
  requestAnimationFrame(function(timestamp) {
    redrawFunction.call(me);
    me.drawAnimationFrame();
  });
};
Timeline.prototype.requestRedraw = function(redrawFunction) {
  redrawFunction = redrawFunction || this.defaultRedraw;
  const me = this;
  if (!this.isAnimating) {
    return redrawFunction.call(me);
  }
  if (redrawFunction === this.defaultRedraw) {
    this.redrawRequests.default = true;
  }
  if (redrawFunction === this.repositionRedraw) {
    this.redrawRequests.reposition = true;
  }
};
Timeline.prototype.updateRedrawRequests = function(nextRedrawFunction) {
  if (nextRedrawFunction === this.defaultRedraw) {
    this.redrawRequests.default = false;
    this.redrawRequests.reposition = false;
  }
  if (nextRedrawFunction === this.repositionRedraw) {
    this.redrawRequests.reposition = false;
  }
};
Timeline.prototype.getAnimationRedrawFunction = function() {
  if (this.isDragging) {
    return this.animation.dragRedrawFunction;
  }
  if (this.isPanning || this.isPinching) {
    return this.defaultRedraw;
  }
  if (this.redrawRequests.default) {
    return this.defaultRedraw;
  }
  if (this.redrawRequests.reposition) {
    return this.repositionRedraw;
  }
  return this.animation.redrawFunction || this.animation.defaultRedrawFunction;
};
Timeline.prototype.switchToPositiveRepositionWindow = function() {
  if (this.repositionWindow < 0) {
    let start = this.timescaleManager.startToken;
    this.repositionWindow = start.length + this.repositionWindow;
    start = this.timescaleManager.getNext(start);
    this.timescaleManager.setStartToken(start);
  }
};
Timeline.prototype.zoomToAnim = function(newZoom, complete) {
  if (this.animation.zoom?.stop) {
    this.animation.zoom.stop();
  }
  const startZoom = this.timescaleManager.zoom;
  const duration = 2e3;
  const easingFn = EASINGS.swing;
  const me = this;
  const zoomTween = tween({
    from: startZoom,
    to: newZoom,
    duration,
    easing: easingFn,
    onUpdate(value) {
      me.setZoom(value);
      me.requestRedraw();
    },
    onComplete() {
      if (typeof complete === "function") {
        complete.call(me);
      }
    }
  });
  this.animation.zoom = zoomTween;
};
Timeline.prototype.goToPixelAnim = function(pixels, options = {}) {
  if (this.isPanning && this.animation.pan?.stop) {
    this.animation.pan.stop();
  }
  this.isPanning = true;
  const MAX_MOVE = 1e8;
  let cappedMove = false;
  if (Math.abs(pixels) > MAX_MOVE) {
    pixels = Math.sign(pixels) * MAX_MOVE;
    cappedMove = true;
  }
  this.startAnimation();
  let lastPos = 0;
  const me = this;
  const panTween = tween({
    from: 0,
    to: pixels,
    duration: options.duration ?? 2e3,
    easing: EASINGS[options.easing] || EASINGS.swing,
    onUpdate(value) {
      const movement = value - lastPos;
      lastPos = value;
      me.updateFromByPixels(movement);
      if (me.isPinching) {
        me.isPanning = false;
        panTween.stop();
      } else {
        me.requestRedraw();
      }
    },
    onComplete() {
      if (cappedMove && options.targetDmy) {
        me.setStartDate(options.targetDmy);
      }
      me.isPanning = false;
      options.complete?.call(me);
    }
  });
  this.animation.pan = panTween;
};
Timeline.prototype.goToDateAnim = function(dmy, options = {}) {
  this.switchToPositiveRepositionWindow();
  this.getDmyFromInput(dmy);
  const startDate = this.timescaleManager.startToken.value;
  let pixels = this.repositionWindow - this.timescaleManager.getPixelsBetween(dmy, startDate);
  if (options.offsetX) {
    pixels -= options.offsetX;
  }
  options.targetDmy = dmy;
  this.goToPixelAnim(pixels, options);
};
Timeline.prototype.repositionWithAnim = function(article) {
  const pos = this.getOriginalPosition(article);
  article.registeredPosition = pos;
  const destination = { left: pos.left + article.dragFinishOffset.left, top: pos.top + article.dragFinishOffset.top };
  article.moveToWithAnim(destination);
};
Timeline.prototype.notifyArticleAnimating = function(animationType, articleId) {
  const now = (/* @__PURE__ */ new Date()).getTime();
  const duration = this.options.article.animation[animationType].duration;
  const endTime = now + duration;
  if (endTime > this.lastAnimatingArticle.endTime) {
    this.lastAnimatingArticle.id = articleId;
    this.lastAnimatingArticle.endTime = endTime;
    this.lastAnimatingArticle.animationType = animationType;
  }
  this.isAnimatingArticles = true;
  this.startAnimation();
};
Timeline.prototype.toggleAutoFit = function() {
  const isFitToHeightOn = this.options.article.autoStacking.fitToHeight = !this.options.article.autoStacking.fitToHeight;
  if (isFitToHeightOn) {
    this.fitToHeight(true);
  }
  return isFitToHeightOn;
};
Timeline.prototype.fitToHeight = function(withRedraw) {
  const numberOfRows = this.topRow + 1;
  if (numberOfRows === 1) {
    return;
  }
  const rowSpacing = this.options.article.autoStacking.rowSpacing = this.getFitToHeightRowSpacing();
  if (withRedraw) {
    this.requestRedraw();
  }
  return rowSpacing;
};
Timeline.prototype.getFitToHeightRowSpacing = function() {
  const options = this.options;
  const firstRowTop = this.top - options.article.distanceToMainLine;
  let lastRowTop = getValueOrFunctionResult(options.article.autoStacking.topGap, this);
  if (options.style.mainLine.position === "top") {
    lastRowTop -= options.verticalOffset;
  }
  const topRowNumber = this.topRow;
  if (topRowNumber == 0) {
    return false;
  }
  const stackingSpace = Math.abs(firstRowTop - lastRowTop);
  const numberOfRows = topRowNumber;
  return Math.max(Math.round(stackingSpace / numberOfRows), 1);
};
Timeline.prototype.incrementRowSpacing = function(change, withRedraw) {
  this.options.article.rowSpacing = Math.max(this.options.article.rowSpacing + change, 1);
  if (withRedraw) {
    this.requestRedraw();
  }
  return this.options.article.rowSpacing;
};
Timeline.prototype.on = function(event, callback) {
  if (typeof event === "object") {
    return this.onMultiple(event);
  }
  if (!this.handlers[event]) {
    this.handlers[event] = [];
  }
  this.handlers[event].push(callback);
};
Timeline.prototype.trigger = function(event, ...callbackData) {
  if (!this.handlers[event]) {
    return;
  }
  const handlers = this.handlers[event];
  for (let i = 0; i < handlers.length; i++) {
    handlers[i].call(this, ...callbackData);
  }
};
Timeline.prototype.onMultiple = function(handlers) {
  for (const event in handlers) {
    this.on(event, handlers[event]);
  }
};
Timeline.prototype.off = function(event, callback) {
  if (typeof event === "object") {
    return this.offMultiple(event);
  }
  if (!this.handlers[event]) {
    return;
  }
  this.handlers[event] = this.handlers[event].filter((cb) => cb !== callback);
};
Timeline.prototype.offMultiple = function(handlers) {
  for (const event in handlers) {
    this.off(event, handlers[event]);
  }
};
function roundPixel(value) {
  return Math.round(value);
}
__name(roundPixel, "roundPixel");
function createInnerSpace(outerSpace, borderWidth, snap) {
  if (!snap) {
    snap = roundPixel;
  }
  const halfBorder = borderWidth / 2;
  return {
    left: snap(outerSpace.left + halfBorder),
    top: snap(outerSpace.top + halfBorder),
    width: snap(outerSpace.width - borderWidth),
    height: snap(outerSpace.height - borderWidth)
  };
}
__name(createInnerSpace, "createInnerSpace");
const landscape = {
  name: "landscape",
  draw(ctx) {
    if (!this.isDataLoaded || isNaN(this.position.left)) {
      return;
    }
    const style = this._getCurrentStyle();
    const top = Math.floor(this.position.top);
    const left = Math.floor(this.position.left);
    const width = style.width;
    const height = style.height;
    const backgroundColor = style.backgroundColor || "#FFF";
    const shadow = style.shadow;
    const borderRadius = style.borderRadius || 0;
    applyShadow(ctx, shadow);
    ctx.fillStyle = backgroundColor;
    if (borderRadius > 0) {
      drawRoundedRect(ctx, left, top, width, height, borderRadius);
      ctx.fill();
    } else {
      ctx.fillRect(left, top, width, height);
    }
    noShadow(ctx);
    let textAreaLeft = left;
    let textAreaWidth = width;
    if (this.imageLoaded) {
      const imageStyle = style.image;
      const imageMargin = imageStyle.margin;
      const imageLeft = left + imageMargin;
      const imageTop = top + imageMargin;
      const imageSize = height - imageMargin * 2;
      let sx, sy, sWidth, sHeight;
      if (this.image.width > this.image.height) {
        sx = roundPixel((this.image.width - this.image.height) / 2);
        sy = 0;
        sWidth = sHeight = this.image.height;
      } else {
        sx = 0;
        sy = 0;
        sWidth = sHeight = this.image.width;
      }
      const imageShape = imageStyle.shape || "square";
      const imageBorderRadius = imageStyle.borderRadius || 0;
      const drawWithOptionalRadius = /* @__PURE__ */ __name((sx2, sy2, sWidth2, sHeight2, dx, dy, dWidth, dHeight) => {
        if (imageBorderRadius > 0) {
          ctx.save();
          drawRoundedRect(ctx, dx, dy, dWidth, dHeight, imageBorderRadius);
          ctx.clip();
          ctx.drawImage(this.image, sx2, sy2, sWidth2, sHeight2, dx, dy, dWidth, dHeight);
          ctx.restore();
        } else {
          ctx.drawImage(this.image, sx2, sy2, sWidth2, sHeight2, dx, dy, dWidth, dHeight);
        }
      }, "drawWithOptionalRadius");
      switch (imageShape) {
        case "circle": {
          drawCircleImage(ctx, this.image, sx, sy, sWidth, sHeight, imageLeft, imageTop, imageSize);
          break;
        }
        case "square": {
          drawWithOptionalRadius(
            sx,
            sy,
            sWidth,
            sHeight,
            imageLeft,
            imageTop,
            imageSize,
            imageSize
          );
          break;
        }
        case "natural":
        default: {
          const scale = Math.min(imageSize / this.image.width, imageSize / this.image.height);
          const dWidth = this.image.width * scale;
          const dHeight = this.image.height * scale;
          const dx = roundPixel(imageLeft + (imageSize - dWidth) / 2);
          const dy = roundPixel(imageTop + (imageSize - dHeight) / 2);
          drawWithOptionalRadius(
            0,
            0,
            this.image.width,
            this.image.height,
            dx,
            dy,
            dWidth,
            dHeight
          );
          break;
        }
      }
      textAreaLeft = left + imageSize + imageMargin;
      textAreaWidth = width - imageSize - imageMargin;
    }
    const showStar = this.owner?.options?.article?.star?.visible !== false && (this.isActive || this.isStarred);
    if (showStar) {
      const starSide = style.star.width;
      const starMargin = style.star.margin;
      const starReserved = starSide + starMargin;
      textAreaWidth = Math.max(0, textAreaWidth - starReserved);
    }
    const headerText = style.header.text;
    const headerTextMargin = headerText.margin;
    const headerTextLineHeight = headerText.lineHeight;
    const headerTextLeft = textAreaLeft + headerTextMargin;
    const headerTextWidth = textAreaWidth - headerTextMargin * 2;
    const headerTextOffsetY = headerText.offsetY || 0;
    const title = this.title;
    const maxNumberOfLines = headerText.numberOfLines;
    const titleLines = this.memo(
      `titleLines:${title}:${headerTextWidth}:${headerText.font}:${maxNumberOfLines}`,
      () => {
        ctx.font = headerText.font;
        let titleLines2 = getTextLines(title, ctx, headerTextWidth);
        if (titleLines2.length > maxNumberOfLines) {
          titleLines2 = truncateTextLines(titleLines2, maxNumberOfLines, ctx, headerTextWidth);
        }
        return titleLines2;
      }
    );
    const headerLineCount = titleLines.length;
    const headerMetrics = this.memo(`headerMetrics:${headerText.font}`, () => {
      ctx.font = headerText.font;
      return ctx.measureText("Hg");
    });
    const headerAscent = headerMetrics.actualBoundingBoxAscent;
    headerMetrics.actualBoundingBoxDescent;
    const subtitleText = `${this.subtitle}`;
    const subheaderText = style.subheader.text;
    const subheaderTextFont = subheaderText.font;
    const subheaderTextMargin = subheaderText.margin;
    subheaderText.lineHeight;
    const subheaderTextLeft = textAreaLeft + subheaderTextMargin;
    const subheaderTextWidth = textAreaWidth - subheaderTextMargin * 2;
    const subheaderTextOffsetY = subheaderText.offsetY || 0;
    const subtitle = this.memo(
      `subtitle:${subtitleText}:${subheaderTextWidth}:${subheaderTextFont}`,
      () => {
        ctx.font = subheaderTextFont;
        const subtitleLines = getTextLines(subtitleText, ctx, subheaderTextWidth);
        const truncatedSubtitle = subtitleLines.length > 1 ? truncateTextLines(subtitleLines, 1, ctx, subheaderTextWidth)[0] : subtitleLines[0];
        return truncatedSubtitle;
      }
    );
    const subheaderMetrics = this.memo(`subheaderMetrics:${subheaderTextFont}`, () => {
      ctx.font = subheaderTextFont;
      return ctx.measureText("Hg");
    });
    const subAscent = subheaderMetrics.actualBoundingBoxAscent;
    const subDescent = subheaderMetrics.actualBoundingBoxDescent;
    const headerBlockHeight = headerLineCount * headerTextLineHeight;
    const subtitleBlockHeight = subAscent + subDescent;
    const totalTextHeight = headerBlockHeight + subtitleBlockHeight;
    const textAreaTop = roundPixel(top + (height - totalTextHeight) / 2);
    let y = textAreaTop + headerAscent + headerTextOffsetY;
    ctx.font = headerText.font;
    ctx.fillStyle = headerText.color;
    ctx.textAlign = headerText.align;
    ctx.textBaseline = headerText.baseline;
    for (let i = 0; i < titleLines.length; i++) {
      ctx.fillText(titleLines[i], headerTextLeft, y, headerTextWidth);
      y += headerTextLineHeight;
    }
    y += subheaderTextOffsetY;
    ctx.font = subheaderText.font;
    ctx.fillStyle = subheaderText.color;
    ctx.textAlign = subheaderText.align;
    ctx.textBaseline = subheaderText.baseline;
    ctx.fillText(subtitle, subheaderTextLeft, y, subheaderTextWidth);
    const border = style.border;
    if (border.width > 0) {
      ctx.strokeStyle = border.color;
      ctx.lineWidth = border.width;
      if (borderRadius > 0) {
        drawRoundedRect(ctx, left, top, width, height, borderRadius);
        ctx.stroke();
      } else {
        ctx.strokeRect(left, top, width, height);
      }
    }
    if (showStar) {
      const star = this.getIconBox();
      let starStroke, starFill;
      if (!this.isStarred) {
        if (this.isMouseOverStar) {
          starStroke = "#8A8A8A";
          starFill = "#dfdfdf";
        } else {
          starStroke = "#a5a5a5";
          starFill = "#ebebeb";
        }
      } else {
        if (this.isMouseOverStar) {
          starStroke = "#8A8A8A";
          starFill = "#fff800";
        } else {
          starStroke = "#a5a5a5";
          starFill = "#fff800";
        }
      }
      drawStar(
        ctx,
        star.centreX,
        star.centreY,
        5,
        star.innerRadius,
        star.outerRadius,
        starFill,
        starStroke
      );
    }
  },
  getWidth() {
    return this._getCurrentStyle().width;
  },
  getHeight() {
    return this._getCurrentStyle().height;
  },
  getIconBox() {
    if (this.owner?.options?.article?.star?.visible === false) {
      return false;
    }
    const style = this._getCurrentStyle();
    const sideLength = style.star.width;
    const box = {
      width: sideLength,
      height: sideLength
    };
    const br = style.borderRadius || 0;
    box.left = roundPixel(
      Math.floor(this.position.left) - br / 4 + this._getWidth() - box.width - style.star.margin
    );
    box.top = roundPixel(Math.floor(this.position.top) + br / 4 + style.star.margin);
    box.centreX = roundPixel(box.left + box.width / 2);
    box.centreY = roundPixel(box.top + box.height / 2);
    box.outerRadius = roundPixel(box.width / 2);
    box.innerRadius = roundPixel(box.outerRadius / 2);
    return box;
  },
  defaultStyle: {
    width: 220,
    height: 70,
    // Only used for landscape layout
    borderRadius: 4,
    // Only used for landscape layout
    image: {
      shape: "square",
      margin: 4,
      borderRadius: 4
    },
    header: {
      text: {
        color: "#333",
        baseline: "alphabetic"
      }
    },
    subheader: {
      text: {
        color: "#777",
        baseline: "alphabetic"
      }
    }
  },
  defaultHoverStyle: {
    border: {
      color: "#a6c6e2"
    }
  },
  defaultActiveStyle: {
    header: {
      text: {
        color: "#000"
      }
    },
    subheader: {
      text: {
        color: "#333"
      }
    }
  }
};
function getPixelSnap(article) {
  return roundPixel;
}
__name(getPixelSnap, "getPixelSnap");
const portrait = {
  name: "portrait",
  draw(ctx) {
    const style = this._getCurrentStyle();
    const snap = getPixelSnap();
    const borderWidth = style.border.width;
    const maxBorderWidth = Math.max(
      borderWidth,
      this.hoverStyle?.border?.width || 0,
      this.activeStyle?.border?.width || 0
    );
    const titleHeight = style.header.height;
    const subtitleHeight = style.subheader.height;
    const imageStyle = style.image;
    imageStyle.margin || 0;
    const outerSpace = {
      // snap to pixels to avoid misplaced images and shadows due to floating point calculation
      top: snap(this.position.top),
      left: snap(this.position.left),
      width: snap(this._getWidth()),
      height: snap(this._cachedHeight)
      // height is set already based on options and image loaded height by this.updateCachedSize()
    };
    const contentTop = snap(outerSpace.top + borderWidth / 2);
    const headerBottom = snap(contentTop + titleHeight);
    const subheaderTop = headerBottom;
    const subheaderBottom = subheaderTop + subtitleHeight;
    const innerSpace = createInnerSpace(outerSpace, maxBorderWidth, snap);
    if (style.shadow) {
      applyShadow(ctx, style.shadow);
      ctx.fillStyle = style.backgroundColor;
      ctx.fillRect(
        outerSpace.left,
        outerSpace.top + style.topRadius,
        outerSpace.width,
        outerSpace.height - style.topRadius
      );
      noShadow(ctx);
    }
    ctx.save();
    ctx.beginPath();
    topRoundRectPath(
      ctx,
      outerSpace.left,
      outerSpace.top,
      outerSpace.width,
      outerSpace.height,
      style.topRadius
    );
    ctx.clip();
    ctx.fillStyle = style.color;
    ctx.fillRect(
      outerSpace.left,
      outerSpace.top,
      outerSpace.width,
      snap(titleHeight + borderWidth / 2)
    );
    ctx.restore();
    if (subtitleHeight !== 0) {
      ctx.fillStyle = style.subheader.color;
      ctx.fillRect(outerSpace.left, subheaderTop, outerSpace.width, subtitleHeight);
      ctx.beginPath();
      ctx.lineWidth = 1;
      ctx.moveTo(innerSpace.left + 5, subheaderTop + 1);
      ctx.lineTo(innerSpace.left + 10, subheaderTop - 5);
      ctx.lineTo(innerSpace.left + 15, subheaderTop + 1);
      ctx.closePath();
      ctx.fill();
    }
    const titleTextAlign = style.header.text.align;
    ctx.fillStyle = style.header.text.color;
    ctx.font = style.header.text.font;
    ctx.textAlign = titleTextAlign;
    ctx.textBaseline = style.header.text.baseline;
    const textMargin = style.header.text.margin;
    const lineHeight = style.header.text.lineHeight;
    const textWidth = innerSpace.width - textMargin * 2;
    const maxNumberOfLines = style.header.text.numberOfLines;
    const titleLines = this.memo(
      `titleLines:${this.title}:${textWidth}:${style.header.text.font}:${maxNumberOfLines}`,
      () => {
        ctx.font = style.header.text.font;
        let titleLines2 = getTextLines(this.title, ctx, textWidth);
        if (titleLines2.length > maxNumberOfLines) {
          titleLines2 = truncateTextLines(titleLines2, maxNumberOfLines, ctx, textWidth);
        }
        this.titleLines = titleLines2;
        return titleLines2;
      }
    );
    const numberOfLines = Math.min(maxNumberOfLines, titleLines.length);
    const allTextHeight = (numberOfLines - 1) * lineHeight;
    const availableSpace = titleHeight;
    const baseY = contentTop + (availableSpace - allTextHeight) / 2;
    const titleOriginX = getTextOrigin(
      innerSpace.left,
      innerSpace.width,
      titleTextAlign,
      textMargin,
      snap
    );
    for (let i = 0; i < numberOfLines; i++) {
      const lineY = snap(baseY + i * lineHeight);
      ctx.fillText(titleLines[i], titleOriginX, lineY, textWidth);
    }
    if (style.subheader.height !== 0) {
      const subtitleTextAlign = style.subheader.text.align;
      const subheaderTextMargin = style.subheader.text.margin;
      const subtitleTextWidth = innerSpace.width - subheaderTextMargin * 2;
      ctx.textAlign = subtitleTextAlign;
      ctx.textBaseline = style.subheader.text.baseline;
      ctx.fillStyle = style.subheader.text.color;
      ctx.font = style.subheader.text.font;
      const subtitleText = `${this.subtitle}`;
      const subtitle = this.memo(
        `subtitle:${subtitleText}:${subtitleTextWidth}:${style.subheader.text.font}`,
        () => {
          ctx.font = style.subheader.text.font;
          const subtitleLines = getTextLines(subtitleText, ctx, subtitleTextWidth);
          const truncatedSubtitle = subtitleLines.length > 1 ? truncateTextLines(subtitleLines, 1, ctx, subtitleTextWidth)[0] : subtitleLines[0];
          this.summarisedSubtitle = truncatedSubtitle;
          return truncatedSubtitle;
        }
      );
      const subtitleOriginX = getTextOrigin(
        innerSpace.left,
        innerSpace.width,
        subtitleTextAlign,
        subheaderTextMargin,
        snap
      );
      const subtitleY = snap(subheaderTop + subtitleHeight / 2);
      ctx.fillText(subtitle, subtitleOriginX, subtitleY, subtitleTextWidth);
    }
    if (this.imageLoaded) {
      const imageStyle2 = style.image;
      const imageMargin = imageStyle2.margin || 0;
      titleHeight + style.subheader.height;
      const imageLeft = snap(outerSpace.left + imageMargin);
      const imageTop = snap(subheaderBottom + imageMargin);
      const rawImageWidth = Math.max(0, outerSpace.width - imageMargin * 2);
      const imageWidth = snap(rawImageWidth);
      let imageHeight;
      const imageShape = imageStyle2.shape || "square";
      switch (imageShape) {
        case "circle":
        case "square":
          imageHeight = imageWidth;
          break;
        case "natural":
        default:
          const scale = imageWidth / this.image.width;
          const scaledHeight = this.image.height * scale;
          const maxHeight = imageStyle2.maxHeight || style.maxImageHeight || 400;
          imageHeight = Math.min(scaledHeight, maxHeight);
          break;
      }
      imageHeight = snap(imageHeight);
      ctx.fillStyle = style.backgroundColor;
      ctx.fillRect(imageLeft, imageTop, imageWidth, imageHeight);
      const imageBorderRadius = imageStyle2.borderRadius || 0;
      const drawWithOptionalRadius = /* @__PURE__ */ __name((sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight) => {
        if (imageBorderRadius > 0) {
          ctx.save();
          drawRoundedRect(ctx, dx, dy, dWidth, dHeight, imageBorderRadius);
          ctx.clip();
          ctx.drawImage(this.image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
          ctx.restore();
        } else {
          ctx.drawImage(this.image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
        }
      }, "drawWithOptionalRadius");
      switch (imageShape) {
        case "circle": {
          let sx, sy, sWidth, sHeight;
          if (this.image.width > this.image.height) {
            sx = (this.image.width - this.image.height) / 2;
            sy = 0;
            sWidth = sHeight = this.image.height;
          } else {
            sx = 0;
            sy = (this.image.height - this.image.width) / 2;
            sWidth = sHeight = this.image.width;
          }
          const diameter = imageWidth;
          const dx = imageLeft;
          const dy = imageTop;
          drawCircleImage(ctx, this.image, sx, sy, sWidth, sHeight, dx, dy, diameter);
          break;
        }
        case "square": {
          let sx, sy, sWidth, sHeight;
          if (this.image.width > this.image.height) {
            sx = (this.image.width - this.image.height) / 2;
            sy = 0;
            sWidth = sHeight = this.image.height;
          } else {
            sx = 0;
            sy = (this.image.height - this.image.width) / 2;
            sWidth = sHeight = this.image.width;
          }
          const side = imageWidth;
          const dx = imageLeft;
          const dy = imageTop;
          drawWithOptionalRadius(sx, sy, sWidth, sHeight, dx, dy, side, side);
          break;
        }
        case "natural":
        default: {
          const scale = imageWidth / this.image.width;
          const scaledHeight = this.image.height * scale;
          const maxHeight = imageStyle2.maxHeight || style.maxImageHeight || 400;
          let sx = 0, sy = 0, sWidth = this.image.width, sHeight = this.image.height;
          const dWidth = imageWidth, dHeight = imageHeight;
          const dx = imageLeft, dy = imageTop;
          if (scaledHeight > maxHeight) {
            const cropRatio = maxHeight / scaledHeight;
            sHeight = this.image.height * cropRatio;
            sy = snap((this.image.height - sHeight) / 2);
          }
          drawWithOptionalRadius(sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
          break;
        }
      }
    }
    if (style.border.width > 0) {
      ctx.beginPath();
      topRoundRectPath(
        ctx,
        outerSpace.left,
        outerSpace.top,
        outerSpace.width,
        outerSpace.height,
        style.topRadius
      );
      ctx.lineWidth = style.border.width;
      ctx.strokeStyle = style.border.color;
      ctx.stroke();
    }
    if (this.owner?.options?.article?.star?.visible !== false && (this.isActive || this.isStarred)) {
      const star = getStarBox(this);
      let starStroke, starFill;
      if (!this.isStarred) {
        if (this.isMouseOverStar) {
          starStroke = "#8A8A8A";
          starFill = "#dfdfdf";
        } else {
          starStroke = "#a5a5a5";
          starFill = "#ebebeb";
        }
      } else {
        if (this.isMouseOverStar) {
          starStroke = "#8A8A8A";
          starFill = "#fff800";
        } else {
          starStroke = "#a5a5a5";
          starFill = "#fff800";
        }
      }
      drawStar(
        ctx,
        star.centreX,
        star.centreY,
        5,
        star.innerRadius,
        star.outerRadius,
        starFill,
        starStroke
      );
    }
  },
  getWidth() {
    return this._getCurrentStyle().width;
  },
  getHeight() {
    const style = this._getCurrentStyle();
    const snap = getPixelSnap();
    let imageHeight = 0;
    if (this.imageLoaded) {
      const imageStyle = style.image;
      const imageMargin = imageStyle.margin || 0;
      const imageShape = imageStyle.shape || "square";
      const availableWidth = snap(style.width - style.border.width / 2 - imageMargin * 2);
      switch (imageShape) {
        case "circle":
        case "square":
          imageHeight = availableWidth + imageMargin * 2;
          break;
        case "natural":
        default:
          const scale = availableWidth / this.image.width;
          const scaledHeight = this.image.height * scale;
          const maxHeight = style.image.maxHeight || style.maxImageHeight || 400;
          imageHeight = Math.min(scaledHeight, maxHeight) + imageMargin * 2;
          break;
      }
    }
    const articleTopHeight = snap(style.header.height + style.subheader.height);
    return imageHeight + articleTopHeight + style.border.width;
  },
  getIconBox() {
    if (this.owner?.options?.article?.star?.visible === false) {
      return false;
    }
    const style = this._getCurrentStyle();
    const snap = getPixelSnap();
    const sideLength = style.star.width;
    const box = {
      width: sideLength,
      height: sideLength
    };
    box.left = snap(
      this.position.left - style.topRadius / 4 + this._getWidth() - box.width - style.star.margin
    );
    box.top = snap(this.position.top + style.topRadius / 4 + style.star.margin);
    return box;
  }
};
function getStarBox(article) {
  const style = article._getCurrentStyle();
  const snap = getPixelSnap();
  const sideLength = style.star.width;
  const box = {
    width: sideLength,
    height: sideLength
  };
  box.left = snap(
    article.position.left - style.topRadius / 4 + article._getWidth() - box.width - style.star.margin
  );
  box.top = snap(article.position.top + style.topRadius / 4 + style.star.margin);
  box.centreX = snap(box.left + box.width / 2);
  box.centreY = snap(box.top + box.height / 2);
  box.outerRadius = snap(box.width / 2);
  box.innerRadius = snap(box.outerRadius / 2);
  return box;
}
__name(getStarBox, "getStarBox");
const _cardLayouts = /* @__PURE__ */ new Map();
function _injectDimensionFallbacks(layout) {
  if (typeof layout.getWidth !== "function") {
    layout.getWidth = function() {
      return this._getCurrentStyle().width;
    };
  }
  if (typeof layout.getHeight !== "function") {
    layout.getHeight = function() {
      return this._getCurrentStyle().height;
    };
  }
  if (typeof layout.getIconBox !== "function") {
    layout.getIconBox = function() {
      return false;
    };
  }
  return layout;
}
__name(_injectDimensionFallbacks, "_injectDimensionFallbacks");
function _followAlias(entry) {
  return entry && entry.aliasOf ? _cardLayouts.get(entry.aliasOf) : entry;
}
__name(_followAlias, "_followAlias");
Timeline.registerCardLayout = /* @__PURE__ */ __name(function registerCardLayout(def) {
  if (!def || typeof def !== "object") {
    throw new Error("Card layout definition must be an object");
  }
  const { name, draw, aliasOf } = def;
  if (!name || typeof name !== "string") {
    throw new Error("Card layout must have a unique string 'name'");
  }
  if (aliasOf) {
    _cardLayouts.set(name, { aliasOf });
    return;
  }
  if (typeof draw !== "function") {
    throw new Error(`Card layout "${name}" must implement draw(ctx)`);
  }
  _cardLayouts.set(name, _injectDimensionFallbacks({ ...def }));
  const { defaultStyle, defaultHoverStyle, defaultActiveStyle } = def;
  const layoutStyles = DEFAULT_OPTIONS.article.layoutStyles[name] = {};
  if (defaultStyle) {
    layoutStyles.style = merge({}, defaultStyle);
  }
  if (defaultHoverStyle) {
    layoutStyles.hoverStyle = merge({}, defaultHoverStyle);
  }
  if (defaultActiveStyle) {
    layoutStyles.activeStyle = merge({}, defaultActiveStyle);
  }
}, "registerCardLayout");
Timeline.getCardLayout = /* @__PURE__ */ __name(function getCardLayout(name) {
  const entry = _followAlias(_cardLayouts.get(name));
  if (!entry) {
    Logger.warn(`Unknown card layout "${name}"`);
    return null;
  }
  return entry;
}, "getCardLayout");
Timeline.prototype._getCurrentCardLayoutName = function() {
  return this.options.article.defaultCardLayout;
};
Timeline.prototype.registerCardLayout = Timeline.registerCardLayout;
Timeline.prototype.getCardLayout = Timeline.getCardLayout;
Timeline.registerCardLayout(portrait);
Timeline.registerCardLayout(landscape);
Timeline.registerCardLayout({ name: "default", aliasOf: "portrait" });
Timeline.prototype.getStatusForSave = function() {
  const from = this.timescaleManager.startToken.value;
  const articleSaveInfo = [];
  for (let i = 0; i < this.articles.length; i++) {
    articleSaveInfo.push(this.articles[i].getStatusForSave());
  }
  return JSON.stringify({
    t: this.title,
    o: this.ownerId,
    // set by host app if needed
    z: this.timescaleManager.zoom,
    // d: event spacing removed in current implementation
    fy: from.year,
    fm: from.month,
    fd: from.day,
    w: this.repositionWindow,
    a: articleSaveInfo
  });
};
Timeline.prototype._emitTimelineStateChange = function() {
  if (this && this._isInitialized === true) {
    this.trigger("timeline-state-change", this.getStatusForSave());
  }
};
const Histropedia = {
  Timeline,
  Article,
  Dmy,
  ...constants,
  ...sorters,
  Logger,
  setDebug(enabled) {
    Logger.setEnabled(!!enabled);
  },
  isDebugEnabled() {
    return Logger.isEnabled();
  },
  enableDebug() {
    Logger.setEnabled(true);
  },
  disableDebug() {
    Logger.setEnabled(false);
  }
};
export {
  ARTICLE_DURATION_SORTER,
  ARTICLE_DURATION_YEARS_SORTER,
  ARTICLE_EFFECTIVE_RANK_SORTER,
  ARTICLE_FROM_SORTER,
  ARTICLE_IMAGE_QUEUE_SORTER,
  ARTICLE_POSITION_SORTER,
  ARTICLE_RANK_SORTER,
  ARTICLE_ROW_SORTER,
  ARTICLE_TOP_SORTER,
  ARTICLE_TO_SORTER,
  Article,
  DENSITY_ALL,
  DENSITY_HIGH,
  DENSITY_LOW,
  DENSITY_MEDIUM,
  DENSITY_SETTINGS,
  ERA_MARKER,
  Logger,
  MAJOR_MARKER,
  MINOR_MARKER,
  PRECISION_BILLION_YEARS,
  PRECISION_CENTURY,
  PRECISION_DAY,
  PRECISION_DECADE,
  PRECISION_MILLENNIUM,
  PRECISION_MILLION_YEARS,
  PRECISION_MONTH,
  PRECISION_YEAR,
  RANGE_ALL,
  RANGE_SCREEN,
  Timeline,
  YEAR_PREFIXES,
  ZOOM_100_MILLION_YEARS,
  ZOOM_100_THOUSAND_YEARS,
  ZOOM_10_MILLION_YEARS,
  ZOOM_10_THOUSAND_YEARS,
  ZOOM_BILLION_YEARS,
  ZOOM_CENTURY,
  ZOOM_DAY,
  ZOOM_DECADE,
  ZOOM_MILLENNIUM,
  ZOOM_MILLION_YEARS,
  ZOOM_MONTH,
  ZOOM_YEAR,
  Histropedia as default
};
