# Changelog

## [1.3.3] - 2026-02-04

### Fixed

- **Time Band opacity bleed.** Resets the canvas `globalAlpha` at the start of each Time Band draw so the overlay does not inherit the last rendered article’s fade opacity when it has no image.

## [1.3.2] - 2026-01-25

### Fixed

- **Legacy event handler `this` context.** Preserves the timeline instance as `this` inside legacy event handlers (`onSave`, `onArticleClick`, `onArticleDoubleClick`, `onRedraw`) to maintain backward compatibility with code that relies on `this` referring to the timeline.

## [1.3.1] - 2025-12-18

### Fixed

- **HiDPI shadows.** Aligns shadow dimensions with the canvas DPR to keep shadows constant size and offset according to CSS pixels for high-density displays.
- **Card border toggles.** Prevents `landscape` cards from drawing borders when the border width is set to 0. This was defaulting to 1px if not set, or keeping previously set value if individual articles differed.
- **Card height refresh.** Recalculates card height when border width changes to fix misalignment of the bottom of the article card.

## [1.3.0] - 2025-12-04

### Added

- **Time Bands overlay API.** Introduces a schema and styling model that mirrors article layouts, configured through `options.timeBand` and adjustable post-init with `setOption`/`setStyle` so bands share the same visibility, alignment, and reserved-space controls as articles.
- **Pluggable article card layouts.** A new feature to draw articles using different layouts, which can then be adjusted as before using the style options. Launches with two built-in options: `portrait` (the layout used before this release) and the new `landscape` layout. Layouts can have style options specific to the layout, which override normal style options. Choose layout using `options.article.defaultCardLayout`, or for individual articles call `article.setCardLayout`. Developers can register their own custom layouts, giving them full control over the rendering and click area.
- **EventManager.** Debuts a dedicated event surface that registers via `options.on` or the timeline `.on` helper, spanning 18 events such as `timeline-render-start`, `timeline-render-end`, `timeline-click`, `timeline-state-change`, `article-activated`, pointer enter/leave/move, zoom, wheel, pinch, and viewport drag notifications, plus `.off` for unsubscribing.
- **Rendering and UX options.** Provides `options.canvas` for DPR-aware high definition canvases, cursor configuration, toggles for date indicators and article connectors, marker extension controls, and new article style options such as image shape.
- **Logger and debug toggles.** Ships a centralized `Histropedia.Logger` plus `Histropedia.enableDebug`/`setDebug` helpers so developers can turn on deprecation warnings and internal diagnostics during development.
- **Article data defaults.** `options.article.defaultData` provides a way to set defaults for any fields when loading article data.
- **TypeScript definitions.** Coverage now spans image options, dragging vicinities, article data (`Dmy` helpers and function properties), `PointerEvent` payloads, deprecated handler types, easing options, and more so the full API stays consumable in TypeScript projects.

### Changed

- **Image loading pipeline.** Uses a byte-aware cache, safe eviction ordering, dynamic queue prioritization, `fetchPriority` hints, visible-only enqueueing, aborts for out-of-range requests, and adds `createImageBitmap` support so decoded bitmaps can flow directly into canvas draws.
- **Pointer and tween engine.** Runs entirely on vanilla pointer/tween utilities (no jQuery), bringing smooth trackpad zoom, unified pointer/touch handling, and new animation helpers for article moves, fades, pans, and zoom transitions.
- **Event naming and payloads.** Aligns with the new `EventManager` by standardizing `PointerEvent` payloads, routing background clicks through `timeline-click`, renaming `article-double-click` to `article-dblclick`, and mapping every legacy hook onto the modern event names for backwards compatibility.
- **Text and layout calculations.** Hardens via memoized helpers, a binary-search `ellipsize` routine, and a new font watcher that forces text measurement cache invalidation on load to eliminate fixing on placeholder font sizes.

### Deprecated

All scheduled for removal in v2.0.0

- **Legacy timeline event handlers.** `onRedraw` now maps to `timeline-render-end`/`timeline-render-start`, while `onSave` maps to `timeline-state-change`.
- **Legacy Article event handlers.** `onArticleClick` and `onArticleDoubleClick` are replaced by `article-select`/`article-click` and `article-dblclick` events from the `EventManager`. These options will be removed in 2.0.0.
- **Deprecated style option.** `maxImageHeight` article style option is superceded by `image.maxHeight` to work alongside other new image style options.
- **Deprecated article default option.** `periodLine.defaultHide` article option is superceded by the new generic defaults setting using `defaultData.hidePeriodLine`.

### Removed

- **jQuery dependencies.** Removes every jQuery dependency (DOM size helpers, mousewheel, animation shims, dummy nodes) for a completely dependency free bundle.
- **Legacy handlers and pub/sub.** Removes legacy click, double-click, and background click handlers plus the old pub/sub implementation after migrating to the `EventManager`.
- **Unused modules.** Removes unused storage modules and legacy helper functions.

### Fixed

- **Drag release handling.** Keeps dragging state from sticking when users release the mouse or touch outside the browser window or an embedded iframe so interactions always complete cleanly.
- **Font loading.** Prevents squashed text when custom fonts were still loading during timeline init by waiting for the new font watcher to confirm real fonts before caching text measurements.
- **Article sorting with string IDs.** Fixed stable sort order for articles with string `id` values when their ranks are equal by properly handling string comparison in the fallback sorting logic.

### Security

- Adds URL sanitization and configurable image sanitizer options so external article imagery cannot inject unsafe URLs.
- Hardens the deep merge helper against prototype pollution, ensures branding links open with `noopener/noreferrer`, and documents the threat model in `SECURITY.md`.
- Patches npm audit findings and refreshes all dev dependencies to eliminate known vulnerabilities.

### Documentation & Internal

- **Event documentation.** Documents the expanded event surface in a new guide, simplifies the README, and adds explicit license information so the API reference stays accurate.
- **Demo tooling.** Adds a version selector, previous release support, restored legacy widths, and performance scenarios so regressions are easy to compare between releases.
- **Distribution pipeline.** Introduces ES Module and UMD bundles, overhauls the bundler/dev asset pipeline, and adds a build test HTML file to verify outputs.
- **Source restructuring.** Moves code into service-specific folders, splits helpers, simplifies the font watcher, and reorganizes article defaults and engines for maintainability.
- **Tooling and automation.** Adds ESLint with auto-fix hooks, Husky/pre-commit automation, new testing scripts, updated Vitest packages, and commit automation for consistent CI runs.
- **Debugging and performance infrastructure.** Adds logger toggles, a scenario runner, a performance demo with small or large image modes, non-fullscreen test scenarios, and versioned demos to aid regression testing.

---

_Note: All notable changes to this project are documented here, starting from v1.3.0 onward._
